package com.yidianling.consultant.ui.view

import android.annotation.SuppressLint
import android.app.Activity
import android.content.Context
import android.graphics.drawable.BitmapDrawable
import android.text.TextUtils
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.*
import com.bumptech.glide.Glide
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.common.tools.RxImageTool
import com.yidianling.common.tools.RxKeyboardTool
import com.yidianling.consultant.R
import com.yidianling.consultant.constants.ConsultBIConstants
import com.yidianling.consultant.listener.OnFilterConfirmListener
import com.yidianling.consultant.model.bean.AllFilter
import com.yidianling.consultant.model.bean.Filters
import com.yidianling.consultant.model.bean.PriceRangesItem
import com.yidianling.consultant.model.bean.ReorderItem
import kotlinx.android.synthetic.main.consultant_item_filter.view.*
import kotlinx.android.synthetic.main.consultant_ui_filter_popup.view.*
import kotlinx.android.synthetic.main.consultant_ui_filter_popup.view.btnConfirm
import kotlinx.android.synthetic.main.consultant_ui_subject_popup_window.view.*
import kotlin.math.roundToInt


/**
 * 筛选弹窗
 * Created by zqk on 17-9-15.
 */
class FilterPopupWindow(
    private val context: Context,
    private val filterData: Filters,
    private val tempFilter: AllFilter,
    private val sortItems: ArrayList<ReorderItem>
) : PopupWindow(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT) {


    private val showTypeViews: ArrayList<View> = ArrayList()
    private val enquiryViews: ArrayList<View> = ArrayList()
    private val ageViews: ArrayList<View> = ArrayList()
    private val otherViews: ArrayList<View> = ArrayList()
    private val ziZhiViews: ArrayList<View> = ArrayList()
    private val goodAtViews: ArrayList<TextView> = ArrayList()
    private val sortRangeViews: ArrayList<View> = ArrayList() //排序list
    var onFilterConfirmListener: OnFilterConfirmListener? = null

    /**筛选咨询方式一行数量*/
    private val enquirySize = 4

    private var dp5 = 0
    private var dp10 = 0
    private var dp36 = 0
    private var dp46 = 0

    private val popWidth = (RxDeviceTool.getScreenWidth(context))

    init {
        val view = LayoutInflater.from(context).inflate(R.layout.consultant_ui_filter_popup, null)

        dp5 = RxImageTool.dip2px(5f)
        dp10 = RxImageTool.dip2px(10f)
        dp36 = RxImageTool.dip2px(36f)
        dp46 = RxImageTool.dip2px(46f)
        this.width = popWidth
        this.height = (RxDeviceTool.getAppHeight(context) * 0.75).toInt()
        contentView = view


        this.isFocusable = true
        @Suppress("DEPRECATION")
        this.setBackgroundDrawable(BitmapDrawable())
        this.isOutsideTouchable = true

//        this.animationStyle = R.style.consultant_expert_service_popupwindow_filter_anim_style
        initShowSortViews(view)
        initShowTypeViews(view)
        //咨询方式
        initEnquiryViews(view)
        //年龄选择
        initAgeViews(view)
        //其他选择
        initOtherViews(view)
        //擅长人群
        initGoodAtCrowd(view)
        //资质
        initZiZhiViews(view)
        //学历选择
        initEduViews(view)

        updateCount()

        view.btnReset.setOnClickListener {
            reset()
        }
        view.btnConfirm.setOnClickListener {
            if (tempFilter.priceRanges?.key1 == "avg_price" && filterData.priceRanges.isNotEmpty()) {
                tempFilter.priceRanges?.key1 = filterData.priceRanges[0].key1
            }
            biEvent(ConsultBIConstants.POSITION_CONSULT_FILTER_CHECKOUT_CLICK)
            onFilterConfirmListener?.onFilterConfirmed()
            dismiss()
        }
    }

    @SuppressLint("UseCompatLoadingForDrawables")
    private fun initShowSortViews(view: View) {
        val mWidth = (popWidth - RxImageTool.dp2px(52f)) / enquirySize
        view.flSortType.removeAllViews()
        for ((index, enquiry) in sortItems.withIndex()) {
            val llTextView =
                View.inflate(context, R.layout.consultant_item_filter, null) as TextView
            val params = FrameLayout.LayoutParams(mWidth, RxImageTool.dp2px(36f))
            val marginNum = RxImageTool.dp2px(5f)
            params.setMargins(
                marginNum + (RxImageTool.dp2px(10f) + mWidth) * (index % enquirySize),
                RxImageTool.dp2px(46f) * (index / enquirySize),
                marginNum,
                0
            )
            llTextView.layoutParams = params
            llTextView.text = enquiry.value

            sortRangeViews.add(llTextView)
            if (enquiry == tempFilter.reorder) {
                llTextView.isSelected = true
                llTextView.background =
                    context.resources.getDrawable(R.drawable.consult_filter_four_selected)
                llTextView.paint.isFakeBoldText = true
                tempFilter.sortRangesView = llTextView
            }
            llTextView.setOnClickListener {
                if (llTextView != tempFilter.sortRangesView) {
                    tempFilter.sortRangesView?.isSelected = false
                    tempFilter.sortRangesView?.background =
                        context.resources.getDrawable(R.drawable.consult_price_expert_unseleted)
                    tempFilter.sortRangesView?.paint?.isFakeBoldText = false
                }
                if (llTextView.isSelected) {
                    tempFilter.sorStyle.remove(enquiry)
                    tempFilter.priceRanges = null
                    llTextView.isSelected = false
                    llTextView.background =
                        context.resources.getDrawable(R.drawable.consult_price_expert_unseleted)
                    llTextView.paint.isFakeBoldText = false
                    tempFilter.sortRangesView = null
                } else {
                    tempFilter.sorStyle.add(enquiry)
                    llTextView.isSelected = true
                    llTextView.background =
                        context.resources.getDrawable(R.drawable.consult_filter_four_selected)
                    llTextView.paint.isFakeBoldText = true
                    tempFilter.sortRangesView = llTextView
                    tempFilter.reorder = sortItems[index]
                }

                updateCount(ConsultBIConstants.POSITION_CONSULT_TYPE_CLICK)
            }
            view.flSortType.addView(llTextView)
        }
    }

    private fun reset() {
        tempFilter.showType = filterData.showType[0]
        tempFilter.ages.clear()
        tempFilter.doctorEdu.clear()
        tempFilter.reorder = ReorderItem()
        // 擅长人群
        tempFilter.specialityCrowd.clear()
        tempFilter.others.clear()
        tempFilter.title.clear()


        for (v in showTypeViews) {
            v.isSelected = false
            if (v is TextView) {
                v.paint.isFakeBoldText = false
            }
        }
        showTypeViews[1].isSelected = true
        for (v in enquiryViews) {
            v.isSelected = false
            val textView: TextView = v.findViewById(R.id.tvFilterName)
            val ivIcon: ImageView = v.findViewById(R.id.iv_consultant_method)
            textView.paint.isFakeBoldText = false

            tempFilter.enquiries.forEach {
                if (textView.text.toString() == it.value) {
                    Glide.with(context)
                        .load(it.un_check_url)
                        .into(ivIcon)
                }
            }
        }
        tempFilter.enquiries.clear()
        for (v in ageViews) {
            v.isSelected = false
            if (v is TextView) {
                v.paint.isFakeBoldText = false
            }
        }
        for (v in goodAtViews) {
            v.isSelected = false
            v.paint.isFakeBoldText = false
        }
        for (v in otherViews) {
            v.isSelected = false
            if (v is TextView) {
                v.paint.isFakeBoldText = false
            }
        }
        for (v in ziZhiViews) {
            v.isSelected = false
            if (v is TextView) {
                v.paint.isFakeBoldText = false
            }
        }
        initZiZhiViews(contentView)
        initOtherViews(contentView)
        initShowSortViews(contentView)
        initShowTypeViews(contentView)
        //咨询方式
        initEnquiryViews(contentView)
        //年龄选择
        initAgeViews(contentView)
        //擅长人群
        initGoodAtCrowd(contentView)

        //学历选择
        initEduViews(contentView)
        updateCount(ConsultBIConstants.POSITION_CONSULT_FILTER_RESET_CLICK)
    }

    //获取筛选结果数
    @SuppressLint("CheckResult")
    private fun updateCount(biEventName: String = "") {
        var showType = 0
        val sb = StringBuffer()
        var biEventParams = ""

        sb.append("searchWord=")
            .append(if (TextUtils.isEmpty(tempFilter.searchWord)) "" else tempFilter.searchWord)
        if (tempFilter.categories.isNotEmpty()) {
            var categorys = tempFilter.categories.map { it.cateId }.joinToString(",")
            if ("0" == categorys) {
                categorys = ""
            }
            sb.append("&directionTags=").append(categorys)
        }
        if (tempFilter.sub.key != null) {
            sb.append("&city=").append(Integer.parseInt(tempFilter.sub.key))
        }
        if (tempFilter.region.key != null) {
            sb.append("&province=").append(Integer.parseInt(tempFilter.region.key))
        }
        if (tempFilter.reorder.key != null) {
            sb.append("&reorder=").append(tempFilter.reorder.key)
        }
        if (tempFilter.enquiries.isNotEmpty()) {
            sb.append("&enquirys=").append(tempFilter.enquiries.map { it.key }.joinToString(","))
            if (ConsultBIConstants.POSITION_CONSULT_TYPE_CLICK == biEventName) {
                biEventParams = tempFilter.enquiries.map { it.key }.joinToString(",")
            }
        }
        if (tempFilter.ages.isNotEmpty()) {
            sb.append("&ages=").append(tempFilter.ages.map { it.key }.joinToString(","))
            if (ConsultBIConstants.POSITION_AGE_CHOICE_CLICK == biEventName) {
                biEventParams = tempFilter.ages.map { it.key }.joinToString(",")
            }
        }
        //学历
        if (tempFilter.doctorEdu.isNotEmpty()) {
            sb.append("&edus=").append(tempFilter.doctorEdu.map { it.key }.joinToString(","))
            if (ConsultBIConstants.POSITION_EDU_CHOICE_CLICK == biEventName) {
                biEventParams = tempFilter.doctorEdu.map { it.value }.joinToString(",")
            }
        }
        if (tempFilter.others.isNotEmpty()) {
            sb.append("&others=").append(tempFilter.others.map { it.key }.joinToString(","))
            if (ConsultBIConstants.POSITION_OTHER_CHOICE_CLICK == biEventName) {
                biEventParams = tempFilter.others.map { it.key }.joinToString(",")
            }
        }
        if (tempFilter.showType.key != null) {
            showType = tempFilter.showType.key!!
            sb.append("&showType=").append(tempFilter.showType.key!!)
        }
        if (tempFilter.title.isNotEmpty()) {
            sb.append("&title=").append(tempFilter.title.map { it.key }.joinToString(","))
            if (ConsultBIConstants.POSITION_QUALIFICATION_CHOICE_CLICK == biEventName) {
                biEventParams = tempFilter.title.map { it.key }.joinToString(",")
            }
        }

        if (tempFilter.priceRanges != null) {
            sb.append("&minPrice=").append(tempFilter.priceRanges?.min_price)
            sb.append("&maxPrice=").append(tempFilter.priceRanges?.max_price)
            if (ConsultBIConstants.POSITION_AVERAGE_SERVICE_INPUT == biEventName) {
                var account = 0.0
                if (!TextUtils.isEmpty(tempFilter.priceRanges?.min_price)) {
                    account += tempFilter.priceRanges?.min_price?.toDouble()!!
                }
                if (!TextUtils.isEmpty(tempFilter.priceRanges?.max_price)) {
                    account += tempFilter.priceRanges?.max_price?.toDouble()!!
                }

                biEventParams = ((account / 2).roundToInt()).toString()
            }
        }

        //用户行为数据埋点
        biEvent(biEventName, biEventParams)

//        ExpertSearchDataManager.getHttp().getFilterCount(sb.toString())
//            .subscribeOn(Schedulers.io())
//            .compose(RxUtils.resultJavaData())
//            .map { it }
//            .filter { true }
//            .observeOn(AndroidSchedulers.mainThread())
//            .subscribe({
//
//                contentView.btnConfirm.text = if (it > 0) "确定" else "暂无匹配咨询师"
//                //按钮置灰/解除置灰
//                contentView.btnConfirm.isEnabled = it > 0
//                if (it > 0) {
//                    contentView.btnConfirm.setTextColor(
//                        ContextCompat.getColor(
//                            context,
//                            R.color.platform_but_text_color
//                        )
//                    )
//                    contentView.btnConfirm.background =
//                        ContextCompat.getDrawable(context, R.drawable.consultant_bg_radius_5_dark)
////                        contentView.btnConfirm.setTextColor(ContextCompat.getColor(context,R.color.consultant_white))
//                } else {
//                    contentView.btnConfirm.setTextColor(
//                        ContextCompat.getColor(
//                            context,
//                            R.color.platform_text_light_color
//                        )
//                    )
//                    contentView.btnConfirm.background =
//                        ContextCompat.getDrawable(context, R.drawable.consultant_bg_radius_5_light)
////                        contentView.btnConfirm.setTextColor(ContextCompat.getColor(context,R.color.color_999999))
//                }
//
//            }, {
//                ToastHelper.show(it.message!!)
//            })
    }

    private fun biEvent(biEventName: String, biEventParams: String = "") {
        if (!TextUtils.isEmpty(biEventName)) {
            ActionCountUtils.count(
                ConsultBIConstants.PART_ID_CONSULT_FILTER_PAGE + "|" + biEventName,
                biEventParams
            )
        }
    }


    /**
     * 其他选择
     * */
    private fun initOtherViews(view: View) {
        val mWidth = (popWidth - RxImageTool.dp2px(52f)) / enquirySize
        view.flOther.removeAllViews()
        for ((index, other) in filterData.other.withIndex()) {
            val textView = View.inflate(context, R.layout.consultant_item_filter, null) as TextView
            val params = FrameLayout.LayoutParams(mWidth, dp36)
            val marginNum = dp5
            params.setMargins(
                marginNum + (dp10 + mWidth) * (index % enquirySize),
                RxImageTool.dp2px(46f) * (index / enquirySize),
                marginNum,
                0
            )
            textView.layoutParams = params
            textView.text = other.value

            otherViews.add(textView)
            if (tempFilter.others.contains(other)) {
                textView.isSelected = true
                textView.paint.isFakeBoldText = true
                textView.background =
                    context.resources.getDrawable(R.drawable.consult_filter_four_selected)
            }
            textView.tvFilterName.text = "   " + other.value + "   "
            textView.setOnClickListener {

                if (textView.isSelected) {
                    tempFilter.others.remove(other)
                    textView.isSelected = false
                    textView.paint.isFakeBoldText = false
                    textView.background =
                        context.resources.getDrawable(R.drawable.consult_price_expert_unseleted)
                } else {
                    tempFilter.others.add(other)
                    textView.isSelected = true
                    textView.paint.isFakeBoldText = true
                    textView.background =
                        context.resources.getDrawable(R.drawable.consult_filter_four_selected)
                }
                updateCount(ConsultBIConstants.POSITION_OTHER_CHOICE_CLICK)
            }
            view.flOther.addView(textView)
        }
    }

    /**
     * 资质
     * */
    private fun initZiZhiViews(view: View) {
        val mWidth = (popWidth - RxImageTool.dp2px(40f)) / 2
        view.flZhizi.removeAllViews()
        for (other in filterData.title) {
            val textView = View.inflate(context, R.layout.consultant_item_filter, null) as TextView
            val params = FrameLayout.LayoutParams(mWidth, dp36)
            params.setMargins(0, 0, RxImageTool.dp2px(10f), 0)
            textView.layoutParams = params
            textView.text = other.value

            ziZhiViews.add(textView)
            if (tempFilter.title.contains(other)) {
                textView.isSelected = true
                textView.paint.isFakeBoldText = true
                textView.background =
                    context.resources.getDrawable(R.drawable.consultant_filter_expert_two_selected)
            }
            textView.tvFilterName.text = "   " + other.value + "   "
            textView.setOnClickListener {
                if (textView.isSelected) {
                    tempFilter.title.remove(other)
                    textView.isSelected = false
                    textView.paint.isFakeBoldText = false
                    textView.background =
                        context.resources.getDrawable(R.drawable.consult_price_expert_unseleted)
                } else {
                    tempFilter.title.add(other)
                    textView.isSelected = true
                    textView.paint.isFakeBoldText = true
                    textView.background =
                        context.resources.getDrawable(R.drawable.consultant_filter_expert_two_selected)
                }
                updateCount(ConsultBIConstants.POSITION_QUALIFICATION_CHOICE_CLICK)
            }
            view.flZhizi.addView(textView)
        }
    }

    /**
     *    擅长人群
     */
    private fun initGoodAtCrowd(view: View) {
        // 如果标标签数量大于20，取前20个默认展示
        view.fl_crowd.removeAllViews()
        if (filterData.specialityCrowd.size > 20) {
            view.ll_crowd_more.visibility = View.VISIBLE
            view.ll_crowd_more.setOnClickListener {
                val text = view.tv_crowd_open.text
                if (text == "展开") {
                    view.tv_crowd_open.text = "收起"
                    view.iv_crowd_open.setImageResource(R.drawable.ic_crowd_close)
                    for (i in 20 until goodAtViews.size) {
                        goodAtViews[i].visibility = View.VISIBLE
                    }
                } else {
                    view.tv_crowd_open.text = "展开"
                    view.iv_crowd_open.setImageResource(R.drawable.ic_crowd_open)
                    for (i in 20 until goodAtViews.size) {
                        goodAtViews[i].visibility = View.GONE
                    }
                }
            }
        }
        val mWidth = (popWidth - RxImageTool.dp2px(52f)) / enquirySize
        val params = FrameLayout.LayoutParams(mWidth, RxImageTool.dp2px(36f))
        val margin = RxImageTool.dp2px(9.5f)
        filterData.specialityCrowd.forEachIndexed { index, item ->
            val textView = View.inflate(context, R.layout.consultant_item_filter, null) as TextView
            params.setMargins(0, 0, margin, 0)
            textView.layoutParams = params
            textView.text = item.value

            if (tempFilter.specialityCrowd.contains(item)) {
                textView.isSelected = true
                textView.paint.isFakeBoldText = true
                textView.background =
                    context.resources.getDrawable(R.drawable.consult_filter_four_selected)
            }
            textView.tvFilterName.text = "   " + item.value + "   "
            textView.setOnClickListener {

                if (textView.isSelected) {
                    tempFilter.specialityCrowd.remove(item)
                    textView.isSelected = false
                    textView.paint.isFakeBoldText = false
                    textView.background =
                        context.resources.getDrawable(R.drawable.consult_price_expert_unseleted)
                } else {
                    tempFilter.specialityCrowd.add(item)
                    textView.isSelected = true
                    textView.paint.isFakeBoldText = true
                    textView.background =
                        context.resources.getDrawable(R.drawable.consult_filter_four_selected)
                }
            }

            if (index > 19) {
                textView.visibility = View.GONE
            }
            goodAtViews.add(textView)
            view.fl_crowd.addView(textView)
        }

    }

    /**
     * 年龄
     * */
    private fun initAgeViews(view: View) {
        val mWidth = (popWidth - RxImageTool.dp2px(52f)) / enquirySize
        view.flAge.removeAllViews()
        for ((index, age) in filterData.age.withIndex()) {
            val textView = View.inflate(context, R.layout.consultant_item_filter, null) as TextView
            val params = FrameLayout.LayoutParams(mWidth, RxImageTool.dp2px(36f))
            val marginNum = RxImageTool.dp2px(5f)
            params.setMargins(
                marginNum + (dp10 + mWidth) * (index % enquirySize),
                dp46 * (index / enquirySize),
                marginNum,
                0
            )
            textView.layoutParams = params
            textView.text = age.value

            ageViews.add(textView)
            if (tempFilter.ages.contains(age)) {
                textView.isSelected = true
                textView.paint.isFakeBoldText = true
                textView.background =
                    context.resources.getDrawable(R.drawable.consult_filter_four_selected)
            }
            textView.text = "    " + age.value + "    "
            textView.setOnClickListener {

                if (textView.isSelected) {
                    tempFilter.ages.remove(age)
                    textView.isSelected = false
                    textView.paint.isFakeBoldText = false
                    textView.background =
                        context.resources.getDrawable(R.drawable.consult_price_expert_unseleted)
                } else {
                    tempFilter.ages.add(age)
                    textView.isSelected = true
                    textView.paint.isFakeBoldText = true
                    textView.background =
                        context.resources.getDrawable(R.drawable.consult_filter_four_selected)
                }
                updateCount(ConsultBIConstants.POSITION_AGE_CHOICE_CLICK)
            }
            view.flAge.addView(textView)
        }
    }

    /**
     * 学历
     * */
    private fun initEduViews(view: View) {
        val mWidth = (popWidth - RxImageTool.dp2px(52f)) / enquirySize
        view.fl_edu.removeAllViews()
        for ((index, edu) in filterData.doctorEdu.withIndex()) {
            val textView = View.inflate(context, R.layout.consultant_item_filter, null) as TextView
            val params = FrameLayout.LayoutParams(mWidth, RxImageTool.dp2px(36f))
            val marginNum = RxImageTool.dp2px(5f)
            params.setMargins(
                marginNum + (dp10 + mWidth) * (index % enquirySize),
                dp46 * (index / enquirySize),
                marginNum,
                0
            )
            textView.layoutParams = params
            textView.text = edu.value

            ageViews.add(textView)
            if (tempFilter.doctorEdu.contains(edu)) {
                textView.isSelected = true
                textView.paint.isFakeBoldText = true
                textView.background =
                    context.resources.getDrawable(R.drawable.consult_filter_four_selected)
            }
            textView.text = "    " + edu.value + "    "
            textView.setOnClickListener {

                if (textView.isSelected) {
                    tempFilter.doctorEdu.remove(edu)
                    textView.isSelected = false
                    textView.paint.isFakeBoldText = false
                    textView.background =
                        context.resources.getDrawable(R.drawable.consult_price_expert_unseleted)
                } else {
                    tempFilter.doctorEdu.add(edu)
                    textView.isSelected = true
                    textView.paint.isFakeBoldText = true
                    textView.background =
                        context.resources.getDrawable(R.drawable.consult_filter_four_selected)
                }
                updateCount(ConsultBIConstants.POSITION_EDU_CHOICE_CLICK)
            }
            view.fl_edu.addView(textView)
        }
    }

    private fun initEnquiryViews(view: View) {
        val mWidth = (popWidth - RxImageTool.dp2px(52f)) / enquirySize
        view.flEnquiryType.removeAllViews()
        for ((index, enquiry) in filterData.enquiry.withIndex()) {
            val llLayout = View.inflate(context, R.layout.consultant_method_item_filter, null)
            val textView: TextView = llLayout.findViewById(R.id.tvFilterName)
            val ivIcon: ImageView = llLayout.findViewById(R.id.iv_consultant_method)
            val params = FrameLayout.LayoutParams(mWidth, RxImageTool.dp2px(36f))
            val marginNum = RxImageTool.dp2px(5f)
            params.setMargins(
                marginNum + (RxImageTool.dp2px(10f) + mWidth) * (index % enquirySize),
                RxImageTool.dp2px(46f) * (index / enquirySize),
                marginNum,
                0
            )
            llLayout.layoutParams = params
            textView.text = enquiry.value
            Glide.with(context)
                .load(enquiry.un_check_url)
                .into(ivIcon)

            enquiryViews.add(llLayout)
            if (tempFilter.enquiries.contains(enquiry)) {
                llLayout.isSelected = true
                textView.paint.isFakeBoldText = true
                Glide.with(context)
                    .load(enquiry.check_url)
                    .into(ivIcon)
                llLayout.background =
                    context.resources.getDrawable(R.drawable.consult_filter_four_selected)
            }
            llLayout.setOnClickListener {
                if (llLayout.isSelected) {
                    tempFilter.enquiries.remove(enquiry)
                    llLayout.isSelected = false
                    textView.paint.isFakeBoldText = false
                    Glide.with(context)
                        .load(enquiry.un_check_url)
                        .into(ivIcon)
                    llLayout.background =
                        context.resources.getDrawable(R.drawable.consult_price_expert_unseleted)
                } else {
                    tempFilter.enquiries.add(enquiry)
                    llLayout.isSelected = true
                    textView.paint.isFakeBoldText = true
                    Glide.with(context)
                        .load(enquiry.check_url)
                        .into(ivIcon)
                    llLayout.background =
                        context.resources.getDrawable(R.drawable.consult_filter_four_selected)
                }
                updateCount(ConsultBIConstants.POSITION_CONSULT_TYPE_CLICK)
            }
            view.flEnquiryType.addView(llLayout)
        }
    }


    private fun initShowTypeViews(view: View) {
        val mWidth = (popWidth - RxImageTool.dp2px(42f)) / 2
        view.flShowType.removeAllViews()
        for ((index, showType) in filterData.showType.withIndex()) {
            val textView = View.inflate(context, R.layout.consultant_item_filter, null) as TextView
            val params = FrameLayout.LayoutParams(mWidth, dp36)
            val marginNum = dp5
            var textMarginLeft = marginNum + (dp10 + mWidth) * (index % 2)
            Log.e("Tag", "----------left=$textMarginLeft")
            params.setMargins(
                textMarginLeft,
                0,
                marginNum,
                marginNum
            )
            textView.layoutParams = params
            textView.text = showType.value
            showTypeViews.add(textView)

            if (showType == tempFilter.showType) {
                textView.isSelected = true
                textView.paint.isFakeBoldText = true
            }
            textView.setOnClickListener {

                if (!textView.isSelected) {
                    for (v in showTypeViews) {
                        v.isSelected = false
                        (v as TextView).paint.isFakeBoldText = false
                    }
                    textView.isSelected = true
                    textView.paint.isFakeBoldText = true
                    tempFilter.showType = showType
                }
                updateCount()
            }

            view.flShowType.addView(textView)
        }
    }

    override fun dismiss() {
        super.dismiss()
    }
}