package com.yidianling.consultant.ui.view

import android.content.Context
import android.graphics.drawable.BitmapDrawable
import androidx.recyclerview.widget.LinearLayoutManager
import android.view.LayoutInflater
import android.view.ViewGroup
import android.widget.PopupWindow
import com.yidianling.consultant.R
import com.yidianling.consultant.adapter.SortRecyclerViewAdapter
import com.yidianling.consultant.listener.OnSortItemSelectedListener
import com.yidianling.consultant.model.bean.ReorderItem
import kotlinx.android.synthetic.main.consultant_ui_sort_popup_window.view.*

/**
 * 排序弹窗
 * Created by zqk on 17-9-15.
 */
class SortPopupWindow(val context: Context, sortItems: ArrayList<ReorderItem>, var selectedSort: ReorderItem, onSortItemSelectedListener: OnSortItemSelectedListener)
    : PopupWindow(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT) {

    private var adapter: SortRecyclerViewAdapter

    init {
        val view = LayoutInflater.from(context).inflate(R.layout.consultant_ui_sort_popup_window, null)
        this.contentView = view
        this.isFocusable = true
        @Suppress("DEPRECATION")
        this.setBackgroundDrawable(BitmapDrawable())
        this.isOutsideTouchable = true
        val rvSortItem = view.rvSortItem
        adapter = SortRecyclerViewAdapter(context, sortItems, selectedSort, onSortItemSelectedListener)
        rvSortItem.adapter = adapter
        rvSortItem.layoutManager = LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false)
//        rvSortItem.addItemDecoration(DividerItemDecoration(context, LinearLayoutManager.VERTICAL))
    }

    fun notifyDataSetChanged() {
        adapter.notifyDataSetChanged()
    }
}