package com.yidianling.consultant.ui.view.topView

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydl_image.module.GlideApp
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils
import com.yidianling.consultant.R
import com.yidianling.consultant.bean.ExpertSearchBigShotBean
import com.yidianling.consultant.constants.ConsultBIConstants
import kotlinx.android.synthetic.main.consultant_expert_search_big_shot_one.view.*

class BigShotOneView : LinearLayout {


    constructor(context: Context) : super(context) {
        mContext = context
        initView()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        mContext = context
        initView()
    }

    constructor(context: Context, attrs: AttributeSet, defStyle: Int) : super(
        context,
        attrs,
        defStyle
    ) {
        mContext = context
        initView()
    }

    private var mContext: Context? = null


    private fun initView() {
        layoutParams = LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.WRAP_CONTENT
        )

        orientation = HORIZONTAL
        View.inflate(mContext, R.layout.consultant_expert_search_big_shot_one, this)
    }

    fun setUrl(bean: ExpertSearchBigShotBean) {
        mContext?.let { GlideApp.with(it).load(bean.topicImages[0].imageUrl).into(consultant_one_img_1) }
        consultant_one_img_1.setOnClickListener {
            val h5Params = H5Params(bean.specialTopicUrl, null)
            NewH5Activity.start(context, h5Params)
            ActionCountUtils.count(
                ConsultBIConstants.PART_ID_CONSULT_COUNSELOR_LIST_PAGE + "|" + ConsultBIConstants.POSITION_CONSULT_COUNSELOR_LIST_BANNER_CLICK,
                bean.specialTopicName
            )
        }
    }
}