package com.yidianling.consultant.ui.view.topView

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.LinearSmoothScroller
import androidx.recyclerview.widget.RecyclerView
import com.alibaba.android.arouter.launcher.ARouter
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.router.IYDLRouterConstant
import com.yidianling.common.tools.RxImageTool
import com.yidianling.consultant.ExpertSearchActivity
import com.yidianling.consultant.R
import com.yidianling.consultant.adapter.CategoryDetailAdapter
import com.yidianling.consultant.adapter.EightCategoryAdapter
import com.yidianling.consultant.listener.OnCategoriesSelectedListener
import com.yidianling.consultant.model.bean.AllFilter
import com.yidianling.consultant.model.bean.ChildrenBean
import com.yidianling.consultant.model.bean.EightCategoryBean
import kotlinx.android.synthetic.main.consultant_layout_category_view.view.*

class EightCategoryView : LinearLayout, CategoryDetailAdapter.OutAdapterClicklistener,
    EightCategoryAdapter.OnLeftClickListener {


    constructor(context: Context, singleMultiple: Boolean) : super(context) {
        mContext = context
        initView(singleMultiple)
    }

    constructor(context: Context, attrs: AttributeSet, singleMultiple: Boolean) : super(
        context,
        attrs
    ) {
        mContext = context
        initView(singleMultiple)
    }

    constructor(
        context: Context,
        attrs: AttributeSet,
        defStyle: Int,
        singleMultiple: Boolean
    ) : super(
        context,
        attrs,
        defStyle
    ) {
        mContext = context
        initView(singleMultiple)
    }

    private var mContext: Context? = null
    private var mutableList: MutableList<MutableList<ChildrenBean>>? = null
    private lateinit var mAllfilter: AllFilter
    private var singleMultiple: Boolean = false
    private var eightCategoryListBean = mutableListOf(
        EightCategoryBean("亲子教育", false, false, false),
        EightCategoryBean("情绪压力", false, false, false),
        EightCategoryBean("恋爱情感", false, false, false),
        EightCategoryBean("婚姻家庭", false, false, false),
        EightCategoryBean("个人成长", false, false, false),
        EightCategoryBean("人际关系", false, false, false),
        EightCategoryBean("职场发展", false, false, false),
        EightCategoryBean("心理健康", false, false, false)
    )
    private lateinit var eightCategoryAdapter: EightCategoryAdapter
    private lateinit var categoryRightAdapter: CategoryDetailAdapter
    private val signList = ArrayList<String>()      // 用于埋点
    var onSubjectsSelectedListener: OnCategoriesSelectedListener? = null
    var isDrag = false
    var leftmanager: LinearLayoutManager = LinearLayoutManager(context)
    private fun initView(singleMultiple: Boolean) {
        View.inflate(mContext, R.layout.consultant_layout_category_view, this)
        if (singleMultiple) {
            layoutParams = LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.WRAP_CONTENT
            )
        } else {
            layoutParams = LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT,
                RxImageTool.dp2px(466f)
            )
            ll_view.layoutParams = LinearLayout.LayoutParams(
                LinearLayout.LayoutParams.MATCH_PARENT,
                RxImageTool.dp2px(400f)
            )
        }
        // 重置
        btn_reset.setOnClickListener {
            reset()
        }
        // 确定
        btnConfirm.setOnClickListener {
            onSubjectsSelectedListener?.onCategoriesSelected(signList)
        }
    }

    fun reset() {
        mutableList?.forEachIndexed { index, mutableList ->
            mutableList.forEachIndexed { index, childrenBean ->
                childrenBean.isSelected = false
            }
        }
        mAllfilter.categoryId2List.clear()
        mAllfilter.categoryId3List.clear()
        signList.clear()
        eightCategoryListBean.forEach {
            it.hasData = false
        }

        categoryRightAdapter.notifyDataSetChanged()
        eightCategoryAdapter.notifyDataSetChanged()
    }

    fun setData(
        mutableList: MutableList<MutableList<ChildrenBean>>,
        mAllFilter: AllFilter?,
        onSubjectsSelectedListener: OnCategoriesSelectedListener?,
        singleMultiple: Boolean
    ) {
        this.mutableList = mutableList
        mAllFilter?.let { this.mAllfilter = it }
        if (singleMultiple) {
            eightCategoryListBean.add(0, EightCategoryBean("热门推荐", false, false, false))
        }
        this.onSubjectsSelectedListener = onSubjectsSelectedListener
        this.singleMultiple = singleMultiple
        ComputeSelected(mutableList, mAllFilter)
        eightCategoryAdapter =
            mContext?.let { EightCategoryAdapter(it, eightCategoryListBean, singleMultiple) }!!
        eightCategoryAdapter.setleftClick(this)
        eight_category.layoutManager = LinearLayoutManager(mContext)
        eight_category.adapter = eightCategoryAdapter

        categoryRightAdapter = CategoryDetailAdapter(mContext!!, mutableList, eightCategoryListBean)
        leftmanager = LinearLayoutManager(mContext)
        category_detail.layoutManager = leftmanager
        category_detail.adapter = categoryRightAdapter
        mutableList.forEachIndexed { index, mutable ->
            if (mutable.size > 0 && mutable[0].isSelected) {
                eightCategoryListBean.get(index).hasData = true
                return@forEachIndexed
            }
        }
        eightCategoryAdapter.notifyDataSetChanged()
        categoryRightAdapter.setOutClicklistener(this)
        category_detail.setOnScrollListener(object : RecyclerView.OnScrollListener() {
            override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {
                super.onScrollStateChanged(recyclerView, newState)
                if (newState == RecyclerView.SCROLL_STATE_DRAGGING) {
                    isDrag = false
                }
            }

            override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
                super.onScrolled(recyclerView, dx, dy)
                if (!isDrag) {
                    var firstVisibleItem: Int = leftmanager.findFirstVisibleItemPosition()
                    eightCategoryListBean.forEachIndexed { index, eightCategoryBean ->
                        eightCategoryListBean[index].selected = index == firstVisibleItem
                    }
                    eightCategoryAdapter.notifyDataSetChanged()
                }
            }
        })
    }

    private fun ComputeSelected(
        mutableList: MutableList<MutableList<ChildrenBean>>,
        mAllFilter: AllFilter?
    ) {
        mutableList.forEachIndexed { index, mutable ->
            mutable.forEachIndexed { indexin, childrenBean ->
                if (mAllFilter?.categoryId3List?.contains(childrenBean.cate_id) == true) {
                    childrenBean.isSelected = true
                    eightCategoryListBean.get(index).hasData = true
                    return@ComputeSelected
                }
            }
        }
    }
    override fun outAdapterClick(outPosition: Int, inPosition: Int) {
        //之前的老数据多选分类页。
        if (!singleMultiple) {
            if (inPosition == 0) {
                if (mutableList?.get(outPosition)?.get(0)?.isSelected!!) {
                    mutableList?.get(outPosition)?.get(0)?.isSelected = false
                    mAllfilter.categoryId2List.remove(
                        mutableList?.get(outPosition)?.get(0)?.cate_id
                    )
                    signList.remove(eightCategoryListBean[outPosition].string)
                } else {
                    mutableList?.get(outPosition)?.forEachIndexed { index, _ ->
                        mutableList?.get(outPosition)?.get(index)?.isSelected = index == 0
                        if (index == 0) {
                            mutableList?.get(outPosition)?.get(0)?.cate_id?.let {
                                mAllfilter.categoryId2List.add(
                                    it
                                )
                            }
                            signList.add(eightCategoryListBean[outPosition].string)
                        } else {
                            mAllfilter.categoryId3List.remove(
                                mutableList?.get(outPosition)?.get(index)?.cate_id
                            )
                            signList.remove(mutableList?.get(outPosition)?.get(index)?.cate_name)
                        }
                    }
                }
            } else {
                if (!mutableList?.get(outPosition)
                        ?.get(inPosition)?.isSelected!! && mutableList?.get(
                        outPosition
                    )?.get(0)?.isSelected!!
                ) {
                    mutableList?.get(outPosition)?.get(0)?.isSelected = false
                    mAllfilter.categoryId2List.remove(
                        mutableList?.get(outPosition)?.get(0)?.cate_id
                    )
                    signList.remove(eightCategoryListBean[outPosition].string)
                }
                mutableList?.get(outPosition)?.get(inPosition)?.isSelected =
                    !mutableList?.get(outPosition)?.get(inPosition)?.isSelected!!
                if (mutableList?.get(outPosition)?.get(inPosition)?.isSelected!!) {
                    mutableList?.get(outPosition)?.get(inPosition)?.cate_id?.let {
                        mAllfilter.categoryId3List.add(
                            it
                        )
                    }
                    mutableList?.get(outPosition)
                        ?.get(inPosition)?.cate_name?.let { signList.add(it) }
                } else {
                    mAllfilter.categoryId3List.remove(
                        mutableList?.get(outPosition)?.get(inPosition)?.cate_id
                    )
                    signList.remove(mutableList?.get(outPosition)?.get(inPosition)?.cate_name)
                }
            }
            leftHasData()
            eightCategoryAdapter.notifyDataSetChanged()
            categoryRightAdapter.notifyDataSetChanged()
        } else {
            //单选跳转咨询列表页
            ARouter.getInstance().build("/consult/list")
                .withInt(IYDLRouterConstant.EXTRA_SHOWTYPE, 0)
                .withString(
                    ExpertSearchActivity.CATEID3IN,
                    mutableList?.get(outPosition)?.get(inPosition)?.cate_id
                )
                .withString(
                    IYDLRouterConstant.EXTRA_CATETITLE,
                    mutableList?.get(outPosition)?.get(inPosition)?.cate_name
                )
                .navigation()
            (context as BaseActivity).finish()
        }
    }

    private fun leftHasData() {
        mutableList?.forEachIndexed { index, mutableList ->
            eightCategoryListBean.get(index).hasData = false
            mutableList.forEachIndexed { indexin, childrenBean ->
                if (childrenBean.isSelected) {
                    eightCategoryListBean.get(index).hasData = true
                    return@leftHasData
                }
            }
        }
    }

    override fun onLeftClick(leftPosition: Int) {
        eightCategoryListBean.forEachIndexed { index, eightCategoryBean ->
            eightCategoryListBean[index].selected = index == leftPosition
        }
        eightCategoryAdapter.notifyDataSetChanged()
        isDrag = true
        val smoothScroller: LinearSmoothScroller = LinearTopSmoothScroller(context)
        smoothScroller.targetPosition = leftPosition
        leftmanager.startSmoothScroll(smoothScroller)
    }
}