package com.yidianling.course;

import android.os.Bundle;
import androidx.fragment.app.Fragment;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.ydl.media.view.PlayerFloatHelper;
import com.ydl.ydlcommon.base.BaseActivity;
import com.ydl.ydlcommon.bean.StatusBarOptions;
import com.ydl.ydlcommon.utils.StatusBarUtils;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * 课程首页Activity（心理课程）
 */
@Route(path = "/course/home")
public class CourseActivity extends BaseActivity {

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        StatusBarUtils.Companion.setTransparentForImageView(this, null);
        StatusBarUtils.Companion.statusBarLightMode(this);
        super.onCreate(savedInstanceState);
    }

    @Override
    protected int layoutResId() {
        return R.layout.activity_course;
    }


    @Override
    protected void initDataAndEvent() {
        initTags();
    }


    @NotNull
    @Override
    public StatusBarOptions getStatusViewOptions() {
        return new StatusBarOptions(false, true);
    }


    /**
     * 初始化tab
     */
    private void initTags() {
        Fragment fragment = getSupportFragmentManager().findFragmentById(R.id.content);
        if (fragment == null) {
            fragment = new FlutterCourseHomeFragment();
            getSupportFragmentManager().beginTransaction()
                    .add(R.id.content, fragment)
                    .commit();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        PlayerFloatHelper.Companion.removeResetView();
    }
}
