package com.yidianling.course.courseNew;

import android.content.Context;
import android.text.TextUtils;

import com.ydl.ydl_router.manager.YDLRouterManager;
import com.ydl.ydl_router.manager.YDLRouterParams;
import com.ydl.ydlcommon.router.IYDLRouterConstant;
import com.yidianling.common.tools.LogUtil;

/**
 * Created by Jim on 2018/7/17 0017.
 */

public class LinkUrlRouterProtocol {

    public static void jump(Context context, String url) {
        if (TextUtils.isEmpty(url)) {
            LogUtil.e("jump url is null");
        }
        if (url.startsWith("app://course/category")) {
            int index = splitParam(url);
            //跳转课程列表
            YDLRouterManager.Companion.router(IYDLRouterConstant.ROUTER_COURSE_LIST,
                    new YDLRouterParams().putExtra(IYDLRouterConstant.EXTRA_LISTTYPE, String.valueOf(index)));
        } else if (url.startsWith("http")) {
            //跳转H5页面
            YDLRouterManager.Companion.router(IYDLRouterConstant.ROUTER_H5_H5,
                    new YDLRouterParams().putExtra(IYDLRouterConstant.EXTRA_URL, url), "");
        } else if (url.startsWith("app://course/special")) {
            int id = splitParam(url);
            //跳转课程专题页
            YDLRouterManager.Companion.router(IYDLRouterConstant.ROUTER_COURSE_SPECIAL,
                    new YDLRouterParams().putExtra(IYDLRouterConstant.EXTRA_ID, String.valueOf(id)));
        } else if (url.startsWith("app://course/fineCourse")) {
            int childId = splitParam(url);
            //跳转课程列表--精品课程
            YDLRouterManager.Companion.router(IYDLRouterConstant.ROUTER_COURSE_LIST,
                    new YDLRouterParams().putExtra(IYDLRouterConstant.EXTRA_LISTTYPE, "18")
                            .putExtra(IYDLRouterConstant.EXTRA_ISFREE, String.valueOf(childId)));
        } else {
            YDLRouterManager.Companion.router(url);
        }

    }

    private static int splitParam(String url) {
        try {
            return Integer.valueOf(url.split("\\?")[1].split("=")[1]);
        } catch (Exception e) {
            LogUtil.e(e.toString());
            return 0;
        }
    }

}
