package com.yidianling.course.courseNew.courseList.widget

import android.content.Context
import android.graphics.Typeface
import android.graphics.drawable.BitmapDrawable
import android.view.LayoutInflater
import android.view.ViewGroup
import android.widget.PopupWindow
import android.widget.TextView
import com.yidianling.course.R
import kotlinx.android.synthetic.main.course_filter_popup_window.view.*

/**
 * @author yuanwai
 * @描述:课程-筛选popWindow
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/22
 *
 * @param isFree 免费1-是 2-否,其他则全部展示
 * @param isInvite 是否返利 1是 2否,其他则全部
 * @param isPromotion 是否促销 1是 2否,其他则全部
 */
class CourseFilterPopupWindow(var context: Context, var isFree: Int, var isInvite: Int, var isPromotion: Int,
                              var onFilterSelectedListener: OnFilterSelectedListener)
    : PopupWindow(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT) {
    //付费是否选中  1：选中  0：没选
    private var hasSelectNoFree = 0
    //免费是否选中  1：选中  0：没选
    private var hasSelectFree = 0

    init {
        val view = LayoutInflater.from(context).inflate(R.layout.course_filter_popup_window, null)
        this.contentView = view
        this.isFocusable = true
        @Suppress("DEPRECATION")
        this.setBackgroundDrawable(BitmapDrawable())
        this.isOutsideTouchable = true
        inputMethodMode = PopupWindow.INPUT_METHOD_NEEDED
        view.btn_confirm.setOnClickListener {
            dismiss()
        }
        view.v_zhezhao.setOnClickListener {
            dismiss()
        }

        when (isFree) {//是否免费这项：全选和全不选，意义是一样的
            0 -> {//两项都没选
                setSelect(view.tv_free, false)
                setSelect(view.tv_no_free, false)
            }
            1 -> {//免费
                setSelect(view.tv_free, true)
            }
            2 -> {//付费
                setSelect(view.tv_no_free, true)
            }
            3 -> {//两项都选了
                setSelect(view.tv_free, true)
                setSelect(view.tv_no_free, true)
            }
        }

        when (isPromotion) {//是否促销 1是 2否,其他则全部
            1 -> {
                setSelect(view.tv_promotion, true)
            }
            else -> {
                setSelect(view.tv_promotion, false)
            }
        }

        when (isInvite) {//是否返利 1是 2否,其他则全部
            1 -> {
                setSelect(view.tv_invite, true)
            }
            else -> {
                setSelect(view.tv_invite, false)
            }
        }


        hasSelectNoFree = if (isFree == 2 || isFree == 3) {
            1
        } else {
            0
        }
        hasSelectFree = if (isFree == 1 || isFree == 3) {
            1
        } else {
            0
        }

        view.tv_no_free.setOnClickListener {
            if (hasSelectNoFree == 0) {
                hasSelectNoFree = 1
                setSelect(view.tv_no_free, true)
            } else {
                hasSelectNoFree = 0
                setSelect(view.tv_no_free, false)
            }
        }

        view.tv_free.setOnClickListener {
            if (hasSelectFree == 0) {
                hasSelectFree = 1
                setSelect(view.tv_free, true)
            } else {
                hasSelectFree = 0
                setSelect(view.tv_free, false)
            }
        }

        view.tv_promotion.setOnClickListener {
            if (isPromotion == 1) {
                isPromotion = 0
                setSelect(view.tv_promotion, false)
            } else {
                isPromotion = 1
                setSelect(view.tv_promotion, true)
            }
        }

        view.tv_invite.setOnClickListener {
            if (isInvite == 1) {
                isInvite = 0
                setSelect(view.tv_invite, false)
            } else {
                isInvite = 1
                setSelect(view.tv_invite, true)
            }
        }
        //重置数据
        view.btn_reset.setOnClickListener {
            hasSelectNoFree = 0
            hasSelectFree = 0
            isInvite = 0
            isPromotion = 0

            setSelect(view.tv_invite, false)
            setSelect(view.tv_promotion, false)
            setSelect(view.tv_no_free, false)
            setSelect(view.tv_free, false)
        }

        //确认
        view.btn_confirm.setOnClickListener {
            isFree = if (hasSelectNoFree == 0 && hasSelectFree == 0) {
                0
            } else if (hasSelectNoFree == 0 && hasSelectFree == 1) {
                1
            } else if (hasSelectNoFree == 1 && hasSelectFree == 0) {
                2
            } else {
                3
            }

            onFilterSelectedListener.onFilterSelected(isFree, isInvite, isPromotion)
            dismiss()
        }
    }


    /**
     * 设置选中样式
     */
    private fun setSelect(textView: TextView, boolean: Boolean) {
        if (boolean) {
            textView.setBackgroundResource(R.drawable.course_filter_select_sel)
            textView.typeface = Typeface.defaultFromStyle(Typeface.BOLD)
        } else {
            textView.setBackgroundResource(R.drawable.course_filter_select_nor)
            textView.typeface = Typeface.defaultFromStyle(Typeface.NORMAL)
        }
    }


    interface OnFilterSelectedListener {
        /**
         *  @param isFree 免费1-是 2-否,不传则全部展示
         * @param isInvite 是否返利 1是 2否,不传则全部
         * @param isPromotion 是否促销 1是 2否,不传则全部
         */
        fun onFilterSelected(isFree: Int, isInvite: Int, isPromotion: Int)
    }
}