package com.yidianling.course.coursePlay.model

import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlcommon.mvp.base.BaseModel
import com.yidianling.course.bean.CourseConsultant
import com.yidianling.course.bean.CourseMediaDetailBean
import com.yidianling.course.coursePlay.presenter.IAudioPlayContract
import com.yidianling.course.net.CourseRetrofitUtils
import io.reactivex.Observable

class AudioPlayModelImpl : BaseModel(), IAudioPlayContract.Model {

    override fun getCoursePlayData(courseId: Int): Observable<BaseResponse<CourseMediaDetailBean>> {
        return CourseRetrofitUtils.getCoursePlayData(courseId.toString())
    }

    override fun getConsultantInfo(courseId: Int): Observable<BaseResponse<CourseConsultant>> {
        return CourseRetrofitUtils.getConsultantInfo(courseId.toString())
    }

}