package com.yidianling.course.coursePlay.presenter

import android.content.Intent
import com.ydl.media.audio.model.Music
import com.ydl.ydlcommon.bean.ShareData
import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlcommon.mvp.base.IModel
import com.ydl.ydlcommon.mvp.base.IPresenter
import com.ydl.ydlcommon.mvp.base.IView
import com.ydl.ydlcommon.router.YdlUserInfo
import com.yidianling.course.bean.CourseConsultant
import com.yidianling.course.bean.CourseExtraBean
import com.yidianling.course.bean.CourseMediaBean
import com.yidianling.course.bean.CourseMediaDetailBean
import com.yidianling.user.api.bean.UserResponseBean
import io.reactivex.Observable
import java.util.ArrayList

interface IAudioPlayContract {

    interface View : IView {

        fun showProgressDialog()

        fun dismissProgressDialog()

        fun updateView(bean: CourseExtraBean, from: Int)

        fun setNonWifiTips(show: Boolean)

        fun audioIsPlaying(): Boolean

        fun audioPausePlay()

        fun getAudioMusic(): Music?

        fun loginByOneKeyLogin()

        fun goToConsultantInfo(url: String)

        fun commonPayDialog(userInfo: UserResponseBean.UserInfo, courseId: String)

        fun buyCourseTipDialog()

        fun shareDialog(share: ShareData?)

        fun setTitle(title: String)

        fun load()

        fun close()
    }


    interface Presenter : IPresenter<View> {

        fun getParams(intent: Intent)

        fun getNewIntent(intent: Intent)

        fun getCoursePlayData()

        fun getConsultantInfo()

        fun addCourseOrder()

        fun getPlayPosition(): Int

        fun getPlayList(): List<CourseMediaBean>

        fun togglePlay(playPosition: Int)

        fun isCanLoad(playPosition: Int): Boolean

        fun share()

        fun showFloatView()

        fun convertToMusics(): ArrayList<Music>

    }

    interface Model : IModel {

        fun getCoursePlayData(courseId: Int): Observable<BaseResponse<CourseMediaDetailBean>>

        fun getConsultantInfo(courseId: Int): Observable<BaseResponse<CourseConsultant>>

    }

}