package com.yidianling.course.courseSearch

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.ViewGroup
import com.yidianling.common.tools.RxImageTool
import com.yidianling.course.bean.Course
import com.yidianling.course.courseSearch.view.ICourseSearchView
import com.yidianling.course.widget.CourseItemNewView

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述: 课程搜索页面列表适配器
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/01/07
 */
class CourseSearchAdapter(private val mContext: Context, private val mCourseSearchView: ICourseSearchView, private val list: List<Course>) : RecyclerView.Adapter<RecyclerView.ViewHolder>() {


    private var itemListener: OnItemClick? = null

    private var dp145: Int = 0
    private var dp80: Int = 0

    init {
        dp145 = RxImageTool.dip2px(145f)
        dp80 = RxImageTool.dip2px(80f)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): CourseSearchViewHolder {
        return CourseSearchViewHolder(CourseItemNewView(mContext))
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        val bean = list[position]
        when (holder) {
            is CourseSearchViewHolder -> {
                holder.mView.setData(bean)

                holder.mView.setOnClickListener {
                    itemListener?.onItemClickEvent(position)
                }
            }
        }
    }

    fun setOnItemClickListener(listener: OnItemClick) {
        itemListener = listener
    }

    interface OnItemClick {
        fun onItemClickEvent(position: Int)
    }

    override fun getItemCount(): Int {
        return list.size
    }

    //自定义的ViewHolder，持有每个Item的的所有界面元素
    inner class CourseSearchViewHolder(var mView: CourseItemNewView) : RecyclerView.ViewHolder(mView)
}