package com.yidianling.course.course_special_list.activity

import android.content.Context
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout
import androidx.recyclerview.widget.LinearLayoutManager
import android.view.View
import com.ydl.ydlcommon.base.BaseMvpActivity
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.ydl.ydlcommon.view.swapelayout.YDLAdapterWrapper
import com.ydl.ydlcommon.view.swapelayout.YDLSwipeToLoadHelper
import com.yidianling.common.tools.ToastUtil
import com.yidianling.course.R
import com.yidianling.course.course_special_list.adapter.CourseSpecialListAdapter
import com.yidianling.course.course_special_list.bean.CourseSpecialItemBean
import com.yidianling.course.course_special_list.contract.ICourseSpecialListContract
import com.yidianling.course.course_special_list.event.CourseSpecialListEventImpl
import com.yidianling.course.course_special_list.event.ICourseSpecialListEvent
import com.yidianling.course.course_special_list.presenter.CourseSpecialListPresenterImpl
import kotlinx.android.synthetic.main.course_layout_title_bar.*
import kotlinx.android.synthetic.main.course_special_list_activity.*

/**
 * @author yuanwai
 * @描述:课程专题列表页
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/18
 */
class CourseSpecialListActivity :
    BaseMvpActivity<ICourseSpecialListContract.View, ICourseSpecialListContract.Presenter>(),
    ICourseSpecialListContract.View, SwipeRefreshLayout.OnRefreshListener, YDLSwipeToLoadHelper.LoadMoreListener {

    /**
     * 课程专题事件接口
     */
    private var mCourseSpecialListEvent: ICourseSpecialListEvent? = null
    /**
     * 课程专题列表适配器
     */
    private var mListAdapter: CourseSpecialListAdapter? = null
    /**
     * 适配器包装 处理上拉加载更多
     */
    private var mAdapterWrapper: YDLAdapterWrapper? = null
    /**
     * 下拉刷新组件
     */
    private var mLoadMoreHelper: YDLSwipeToLoadHelper? = null
    /**
     * 页码
     */
    private var page: Int = 1

    override fun getStatusViewOptions(): StatusBarOptions {
        return StatusBarOptions(true, statusBarDarkMode = true)
    }
    override fun createPresenter(): ICourseSpecialListContract.Presenter {
        return CourseSpecialListPresenterImpl(this)
    }

    override fun getContext(): Context {
        return CourseSpecialListActivity@ this
    }

    override fun layoutResId(): Int {
        return R.layout.course_special_list_activity
    }

    override fun initDataAndEvent() {
        initView()
        mCourseSpecialListEvent = CourseSpecialListEventImpl(CourseSpecialListActivity@ this)
        initAdapter()
        //加载本地缓存
        mPresenter.loadLocalData()
        //加载网络接口
        mPresenter.specialListRequest(page)
    }

    private fun initView() {
        iv_back.setOnClickListener {
            finish()
        }
        tv_title.text = resources.getString(R.string.course_special_list_title)
        tv_left_menu.visibility = View.GONE
    }

    /**
     * 初始化适配器
     */
    private fun initAdapter() {
        if (null == mListAdapter) {
            mListAdapter = CourseSpecialListAdapter(ArrayList(), mCourseSpecialListEvent!!)
        }
        //onMeasure中导致mCurrentTargetOffsetTop为负数了 所以需要手动设置下距离 不然 显示不出来 下拉动画 蛋疼
        swipelayout.setProgressViewOffset(false, 0, 52)
        swipelayout.isRefreshing = true
        swipelayout.setOnRefreshListener(this)
        swipelayout.setColorSchemeResources(R.color.platform_main_theme)
        rv_list.layoutManager =
            LinearLayoutManager(this)
        if (null == mAdapterWrapper) {
            mAdapterWrapper = YDLAdapterWrapper(mListAdapter!!)
        }
        mLoadMoreHelper = YDLSwipeToLoadHelper(rv_list, mAdapterWrapper!!)
        mLoadMoreHelper!!.setLoadMoreListener(this)
        rv_list.adapter = mAdapterWrapper
    }

    override fun specialListResponse(list: List<CourseSpecialItemBean>) {
        hideError()
        swipelayout.isRefreshing = false
        mListAdapter!!.updataItems(list)
        // 刷新完成是解禁上拉加载更多
        mLoadMoreHelper!!.setSwipeToLoadEnabled(true)
        if (null == list || list.size < 10) {
            mLoadMoreHelper!!.setNoMoreData()
        }
        mAdapterWrapper!!.notifyDataSetChanged()
    }

    override fun specialListRequestFail() {
        showError()
    }

    override fun loadMoreResponse(list: List<CourseSpecialItemBean>) {
        mListAdapter!!.addItems(list)
        // 刷新完成是解禁上拉加载更多
        if (null == list || list.size < 10) {
            mLoadMoreHelper!!.setNoMoreData()
        } else {
            mLoadMoreHelper!!.setLoadMoreFinish()
        }
        mAdapterWrapper!!.notifyDataSetChanged()
    }

    private fun showError() {
        swipelayout.isRefreshing = false
        rv_list.visibility = View.GONE
        v_no_network.visibility = View.VISIBLE
    }

    private fun hideError() {
        swipelayout.isRefreshing = false
        rv_list.visibility = View.VISIBLE
        v_no_network.visibility = View.GONE
    }

    override fun showError(msg: String?) {
        swipelayout.isRefreshing = false
        ToastUtil.toastShort(msg)
    }

    override fun onRefresh() {
        //禁止上拉加载更多
        mLoadMoreHelper!!.setSwipeToLoadEnabled(false)
        page = 1
        mPresenter.specialListRequest(page)
    }

    override fun onLoad() {
        page++
        mPresenter.specialListRequest(page)
    }
}