package com.yidianling.course.course_special_list.contract

import android.content.Context
import com.ydl.ydlcommon.mvp.base.IModel
import com.ydl.ydlcommon.mvp.base.IPresenter
import com.ydl.ydlcommon.mvp.base.IView
import com.yidianling.course.course_special_list.bean.CourseSpecialItemBean
import com.yidianling.course.course_special_list.bean.CourseSpecialListBean
import com.yidianling.course.course_special_list.bean.CourseSpecialListParam
import io.reactivex.Observable

/**
 * @author yuanwai
 * @描述:课程专题列表页约束类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/18
 */
interface ICourseSpecialListContract {
    //View接口
    interface View : IView {

        /**
         * 课程专题列表页数据请求结果
         * @param list 数据集合
         */
        fun specialListResponse(list: List<CourseSpecialItemBean>)

        /**
         * 课程专题列表加载更多请求结果
         */
        fun loadMoreResponse(list: List<CourseSpecialItemBean>)

        /**
         * 倾诉首页数据请求失败
         */
        fun specialListRequestFail()

        /**
         * 显示错误信息
         */
        fun showError(msg: String?)

        fun getContext(): Context
    }

    interface Presenter : IPresenter<View> {
        /**
         * 加载本地缓存
         */
        fun loadLocalData()

        /**
         * 课程专题列表数据请求
         */
        fun specialListRequest(page: Int)

        /**
         * 课程专题列表加载更多
         */
        fun loadMore(page: Int)
    }

    interface Model : IModel {
        /**
         * 倾诉首页数据请求
         */
        fun specialListRequest(param: CourseSpecialListParam): Observable<CourseSpecialListBean>
    }
}