package com.yidianling.course.course_special_list.presenter

import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.ydl.ydlcommon.data.http.ThrowableConsumer
import com.ydl.ydlcommon.mvp.base.BasePresenter
import com.yidianling.common.tools.RxNetTool
import com.yidianling.course.course_special_list.bean.CourseSpecialItemBean
import com.yidianling.course.course_special_list.contract.ICourseSpecialListContract
import com.yidianling.course.course_special_list.bean.CourseSpecialListParam
import com.yidianling.course.course_special_list.model.CourseSpecialListModelImpl
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.functions.Consumer
import io.reactivex.schedulers.Schedulers

/**
 * @author yuanwai
 * @描述:课程专题列表逻辑实现类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/18
 */
class CourseSpecialListPresenterImpl (var view: ICourseSpecialListContract.View) :
    BasePresenter<ICourseSpecialListContract.View, ICourseSpecialListContract.Model>(),ICourseSpecialListContract.Presenter{
    override fun createModel(): ICourseSpecialListContract.Model {
        return CourseSpecialListModelImpl()
    }

    /**
     * 加载本地缓存
     */
    override fun loadLocalData() {
    }

    override fun specialListRequest(page: Int) {
        if (!RxNetTool.isConnected(view.getContext())){
            view.specialListRequestFail()
            return
        }
        requestList(page,false)
    }

    /**
     * 测试方法
     */
    private fun test(loadMore: Boolean){
        var json = "[{\"id\":123,\"name\":\"教你让孩子赢在起跑线上，情商高的孩子更容易成功\",\"pic\":\"https://img.ydlcdn.com/file/2017/12/21/wmgpjndoczjhk6ld.png\",\"courseNumContent\":\"共12节课程\"},{\"id\":123,\"name\":\"教你让孩子赢在起跑线上，情商高的孩子更容易成功\",\"pic\":\"https://img.ydlcdn.com/file/2017/12/21/wmgpjndoczjhk6ld.png\",\"courseNumContent\":\"共12节课程\"},{\"id\":123,\"name\":\"教你让孩子赢在起跑线上，情商高的孩子更容易成功\",\"pic\":\"https://img.ydlcdn.com/file/2017/12/21/wmgpjndoczjhk6ld.png\",\"courseNumContent\":\"共12节课程\"},{\"id\":123,\"name\":\"教你让孩子赢在起跑线上，情商高的孩子更容易成功\",\"pic\":\"https://img.ydlcdn.com/file/2017/12/21/wmgpjndoczjhk6ld.png\",\"courseNumContent\":\"共12节课程\"},{\"id\":123,\"name\":\"教你让孩子赢在起跑线上，情商高的孩子更容易成功\",\"pic\":\"https://img.ydlcdn.com/file/2017/12/21/wmgpjndoczjhk6ld.png\",\"courseNumContent\":\"共12节课程\"},{\"id\":123,\"name\":\"教你让孩子赢在起跑线上，情商高的孩子更容易成功\",\"pic\":\"https://img.ydlcdn.com/file/2017/12/21/wmgpjndoczjhk6ld.png\",\"courseNumContent\":\"共12节课程\"},{\"id\":123,\"name\":\"教你让孩子赢在起跑线上，情商高的孩子更容易成功\",\"pic\":\"https://img.ydlcdn.com/file/2017/12/21/wmgpjndoczjhk6ld.png\",\"courseNumContent\":\"共12节课程\"},{\"id\":123,\"name\":\"教你让孩子赢在起跑线上，情商高的孩子更容易成功\",\"pic\":\"https://img.ydlcdn.com/file/2017/12/21/wmgpjndoczjhk6ld.png\",\"courseNumContent\":\"共12节课程\"},{\"id\":123,\"name\":\"教你让孩子赢在起跑线上，情商高的孩子更容易成功\",\"pic\":\"https://img.ydlcdn.com/file/2017/12/21/wmgpjndoczjhk6ld.png\",\"courseNumContent\":\"共12节课程\"},{\"id\":123,\"name\":\"教你让孩子赢在起跑线上，情商高的孩子更容易成功\",\"pic\":\"https://img.ydlcdn.com/file/2017/12/21/wmgpjndoczjhk6ld.png\",\"courseNumContent\":\"共12节课程\"}]"
        val gson = Gson()
        val list = gson.fromJson<List<CourseSpecialItemBean>>(json, object : TypeToken<List<CourseSpecialItemBean>>() {}.type)
        if (loadMore){
            view.loadMoreResponse(list)
        }else{
            view.specialListResponse(list)
        }
    }

    override fun loadMore(page: Int) {
        if (!RxNetTool.isConnected(view.getContext())){
            view.showError("网络不给力")
            return
        }
        requestList(page,true)
    }

    /**
     * 接口请求
     * @param page 页码
     * @param loadMore 是否为上拉加载更多
     */
    private fun requestList(page: Int,loadMore : Boolean){
        val disposable = mModel.specialListRequest(
            CourseSpecialListParam(
                page,
                0
            )
        )
                .subscribeOn(Schedulers.io())
                .map { it }
                .filter { it != null }
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(Consumer {
                    if (loadMore){
                        view.loadMoreResponse(it.list?:ArrayList())
                    }else{
                        view.specialListResponse(it.list?:ArrayList())
                    }
                }, object : ThrowableConsumer() {
                    override fun accept(msg: String) {
                        if (loadMore){
                            view.showError(msg)
                        }else{
                            view.specialListRequestFail()
                        }
                    }
                })
    }
}