package com.yidianling.course.flutterPlugin

import com.channel.ydl_flutter_base.base.BaseFlutterFragment
import com.example.fm_plugin.base.FlutterFragment
import io.flutter.plugin.common.EventChannel
import io.flutter.view.FlutterView

/**
 * @author jiucheng
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/10/25
 */
object CourseSendPlugin {
    private var messageChannel: EventChannel? = null
    const val CHANNEL: String = "base/channel/native/post"

    private var mFragment: BaseFlutterFragment? = null
    private var eventSink: EventChannel.EventSink? = null

    fun initContext(fragment: BaseFlutterFragment, view: FlutterView): CourseSendPlugin {
        mFragment = fragment
        messageChannel = EventChannel(view, CHANNEL)
        messageChannel!!.setStreamHandler(object : EventChannel.StreamHandler {
            override fun onListen(p0: Any?, event: EventChannel.EventSink?) {
                eventSink = event
            }

            override fun onCancel(p0: Any?) {
            }
        })
        return this
    }


    fun sendMsg(isPlaying: Boolean) {
        eventSink?.success(isPlaying)
    }


    fun sendRequestData() {
        eventSink?.success("requestData")
    }

    fun sendLoginSuccess() {
        eventSink?.success("loginSuccess")
    }

}