package com.yidianling.course.net;

import android.content.Context;
import com.ydl.ydlcommon.base.config.HttpConfig;
import com.ydl.ydlcommon.data.http.BaseAPIResponse;
import com.ydl.ydlcommon.data.http.BaseResponse;
import com.ydl.ydlcommon.data.http.FormatText;
import com.ydl.ydlcommon.utils.NetworkParamsUtils;
import com.ydl.ydlcommon.utils.remind.HttpErrorUtils;
import com.ydl.ydlnet.YDLHttpUtils;
import com.yidianling.course.bean.*;
import com.yidianling.course.course_special_list.bean.CourseSpecialListBean;
import com.yidianling.course.course_special_list.bean.CourseSpecialListParam;
import com.yidianling.course.model.CourseCategoryBean;
import com.yidianling.course.model.TopicCourseBean;
import io.reactivex.Observable;
import okhttp3.MediaType;
import okhttp3.RequestBody;

import java.util.List;

/**
 * Created by Jim on 2018/2/26 0026.
 */

public class CourseRetrofitUtils {

    public static void handleError(Context context, Throwable e) {
        HttpErrorUtils.Companion.handleError(context, e);
    }


    //课程提交回复
    public static Observable<BaseResponse<Object>> commitCourseReply(Command.CourseCommitReply cmd) {
        List<FormatText> list = NetworkParamsUtils.getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).commitCourseReply(NetworkParamsUtils.getMaps(list));
    }

    //获取课程海报分享数据
    public static Observable<BaseResponse<PostersShareBean>> getPosterData(String courseId) {
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getPosterData(courseId);
    }

    //课程课后笔记列表
    public static Observable<BaseResponse<List<CoursePlayBean.Comments>>> courseReplyList(Command.CourseReplyList cmd) {
        List<FormatText> list = NetworkParamsUtils.getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).courseReplyList(NetworkParamsUtils.getMaps(list));
    }

    //获取课程列表分类
    public static Observable<BaseAPIResponse<CourseCategoryBean>> getCourseListCategory() {
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getCourseListCategory();
    }

    //获取课程专题
    public static Observable<BaseAPIResponse<TopicCourseBean>> getCourseTopic(String id) {
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getCourseSpecial(id);
    }


    /**
     * 获取可以领取的优惠券
     *
     * @param uid         uid
     * @param services    适用服务 1预约咨询 2电话倾诉 3课程（用户课程 专家课程） 5测评
     * @param receiveType 领取条件方式 1前台领取 2链接领取
     * @param applyEnds   适用终端 1PC官网 2wap站点 3用户app 4好杮app 5专家app
     * @return
     */
    public static Observable<BaseResponse<List<CourseCouponBean>>> getCourseCoupons(String uid, String services, String receiveType, String applyEnds) {
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getCourseCoupons(uid, services, receiveType, applyEnds);
    }

    //领取优惠券
    public static Observable<BaseResponse<List<String>>> receiveCoupon(String couponIds) {
        RequestBody body = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), couponIds);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).receiveCoupon(body);
    }

    public static Observable<BaseAPIResponse<CouponHintResponseBean>> getCouponHint(CouponHintParam param) {
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getCouponHint();
    }

    public static Observable<BaseAPIResponse<String>> getCouponMax(RedListParam param) {
        StringBuffer sb = new StringBuffer();
        sb.append("serviceType").append("=").append(param.getServiceType()).append("&");
        String confideParam = sb.toString() + NetworkParamsUtils.getCommonParam();
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getCouponMax(HttpConfig.Companion.getJAVA_BASE_URL() + "auth/coupon/max?" + confideParam);
    }

    public static Observable<BaseAPIResponse<CourseListDataBean>> getCourseList(String url) {
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getCourseList(HttpConfig.Companion.getJAVA_BASE_URL() + "auth/course/getList?" + url);
    }


    /**
     * 获取课程播放页 java 接口
     */
    public static Observable<BaseResponse<CourseMediaDetailBean>> getCoursePlayData(String courseId) {
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getCoursePlayData(courseId);
    }

    /**
     * 获取咨询师上线状态
     */
    public static Observable<BaseResponse<CourseConsultant>> getConsultantInfo(String courseId) {
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getConsultantInfo(courseId);
    }

    public static Observable<BaseAPIResponse<CourseSpecialListBean>> specialListRequest(CourseSpecialListParam param) {
        List<FormatText> list = NetworkParamsUtils.getPostList(param);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).courseSpecialList(NetworkParamsUtils.getMaps(list));
    }

}
