package com.yidianling.course.net;

import com.ydl.ydlcommon.data.http.BaseAPIResponse;
import com.ydl.ydlcommon.data.http.BaseResponse;
import com.yidianling.course.bean.CouponHintResponseBean;
import com.yidianling.course.bean.Course;
import com.yidianling.course.bean.CourseAddOrderBean;
import com.yidianling.course.bean.CourseConsultant;
import com.yidianling.course.bean.CourseCouponBean;
import com.yidianling.course.bean.CourseListDataBean;
import com.yidianling.course.bean.CourseMediaDetailBean;
import com.yidianling.course.bean.CoursePlayBean;
import com.yidianling.course.bean.PostersShareBean;
import com.yidianling.course.course_special_list.bean.CourseSpecialListBean;
import com.yidianling.course.model.CourseCategoryBean;
import com.yidianling.course.model.TopicCourseBean;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;
import retrofit2.http.Url;

import static com.ydl.ydlcommon.base.config.AppConfigKt.YDL_DOMAIN;
import static com.ydl.ydlcommon.base.config.AppConfigKt.YDL_DOMAIN_JAVA;
import static com.ydl.ydlcommon.base.config.AppConfigKt.YDL_DOMAIN_JAVA_URL;

/**
 * Created by Jim on 2018/2/26 0026.
 */

public interface NetApiStore {


    //获取课程列表
    @retrofit2.http.Headers("Content-Type:application/json")
    @GET()
    Observable<BaseAPIResponse<CourseListDataBean>> getCourseList(@Url String url);

    //获取课程列表
    @FormUrlEncoded
    @POST("course/list")
    Observable<BaseResponse<List<Course>>> getPhpCourseList(@FieldMap Map<String, String> params);

    //课程课后笔记列表
    @FormUrlEncoded
    @POST("course/comments")
    Observable<BaseResponse<List<CoursePlayBean.Comments>>> courseReplyList(@FieldMap Map<String, String> params);

    //课程提交回复
    @FormUrlEncoded
    @POST("auth/course/comments/add")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    Observable<BaseResponse<Object>> commitCourseReply(@FieldMap Map<String, String> params);

    //课程播放页--点赞
    @FormUrlEncoded
    @POST("course/zan")
    Observable<BaseResponse<Object>> coursePlayZan(@FieldMap Map<String, String> params);

    //参加课程
    @FormUrlEncoded
    @POST("course/add-order")
    Observable<BaseResponse<CourseAddOrderBean>> addCourseOrder(@FieldMap Map<String, String> params);

    //获取课程海报分享数据
    @GET("auth/course/posters/share")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    Observable<BaseResponse<PostersShareBean>> getPosterData(@Query("id") String courseId);


    //首页分类
    @FormUrlEncoded
    @POST("course/cats")
    Observable<BaseResponse<List<CourseCategoryBean>>> getCourseCats(@FieldMap Map<String, String> params);

    //课程筛选分类
    @GET("auth/course/search/newsample")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    Observable<BaseAPIResponse<CourseCategoryBean>> getCourseListCategory();


    //课程专题列表接口
    @GET("auth/course/new/listCoursesBySpecialId")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    Observable<BaseAPIResponse<TopicCourseBean>> getCourseSpecial(@Query("specialId") String uid);


    /**
     * 获取可以领取的优惠券
     *
     * @param uid         uid
     * @param services    适用服务 1预约咨询 2电话倾诉 3课程（用户课程 专家课程） 5测评
     * @param receiveType 领取条件方式 1前台领取 2链接领取
     * @param applyEnds   适用终端 1PC官网 2wap站点 3用户app 4好杮app 5专家app
     * @return
     */
    @GET("marketing/coupon/new/available")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA_URL)
    Observable<BaseResponse<List<CourseCouponBean>>> getCourseCoupons(@Query("uid") String uid,
                                                                      @Query("services") String services,
                                                                      @Query("receiveType") String receiveType,
                                                                      @Query("applyEnds") String applyEnds);

    //领取优惠券
    @POST("marketing/coupon/new/receives")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA_URL)
    Observable<BaseResponse<List<String>>> receiveCoupon(@Body RequestBody body);


    @GET("auth/coupon/courseCoupon/warn")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    Observable<BaseAPIResponse<CouponHintResponseBean>> getCouponHint();


    //倾诉红包接口
    @retrofit2.http.Headers("Content-Type:application/json")
    @GET
    Observable<BaseAPIResponse<String>> getCouponMax(@Url String url);

    //获取课程播放页 java 接口
    @GET("auth/course/get/all/audio-video")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    Observable<BaseResponse<CourseMediaDetailBean>> getCoursePlayData(@Query("courseId") String courseId);

    //获取咨询师上线状态
    @GET("auth/course/getCourseDoctorInfo")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    Observable<BaseResponse<CourseConsultant>> getConsultantInfo(@Query("courseId") String courseId);


    //课程专题列表
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    @GET("auth/course/listCoursesBySpecialId")
    Observable<BaseAPIResponse<CourseSpecialListBean>> courseSpecialList(@QueryMap Map<String, String> params);
}
