package com.yidianling.course.router

import android.app.Activity
import android.content.Context
import android.content.Intent
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.yidianling.dynamic.api.IDynamicService
import com.yidianling.user.api.service.IUserService

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/04/25
 */
object CourseIn {

    fun getUserService(): IUserService {
        return ModularServiceManager.provide(IUserService::class.java)
    }

    fun getDynamicService(): IDynamicService {
        return ModularServiceManager.provide(IDynamicService::class.java)
    }

    fun isLogin(): Boolean {
        return ModularServiceManager.provide(IUserService::class.java).isLogin()
    }

    fun loginWayIntent(activity: Activity): Intent? {
        return ModularServiceManager.provide(IUserService::class.java).loginWayIntent(activity)
    }

    /**
     * 调用优先使用一键登录，并返回调用时的登录状态，
     * @param isOpenDialog true:一键登录使用弹窗展示 false:一键登录使用全屏模式
     * @return true：已登录，不触发登录跳转，false：未登录，优先一键登录
     * */
    fun loginByOneKeyLogin(context: Context, isOpenDialog: Boolean) :Boolean{
        return ModularServiceManager.provide(IUserService::class.java).loginByOneKeyLogin(context,isOpenDialog)
    }
}