package com.yidianling.course.uitls

import android.content.Context
import android.text.TextUtils

/**
 * 工具类
 * Created by hgw on 2018/3/31.
 */
object VideoProgressUtil {


    /**
     * 保存播放进度
     */
    fun saveProgress(context: Context?, url: String?, progress: Int) {
        if (TextUtils.isEmpty(url)) return
        val shared = context?.getSharedPreferences("COURSE_VIDEO_PROGRESS", Context.MODE_PRIVATE)
        val edit = shared?.edit()
        edit?.putInt(url, progress)
        edit?.apply()
    }

    /**
     * 获取进度
     */
    fun getProgress(context: Context?, url: String?): Int {
        if (TextUtils.isEmpty(url)) return 0
        val shared = context?.getSharedPreferences("COURSE_VIDEO_PROGRESS", Context.MODE_PRIVATE)
        return shared?.getInt(url, 0) ?: 0
    }
}