package com.yidianling.course.widget

import android.annotation.SuppressLint
import android.content.Context
import android.text.TextUtils
import android.util.AttributeSet
import android.view.View
import android.widget.RelativeLayout
import com.ydl.ydl_router.manager.YDLRouterManager
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlcommon.data.http.ThrowableConsumer
import com.ydl.ydlcommon.router.IYDLRouterConstant
import com.yidianling.course.R
import com.yidianling.course.bean.CouponHintParam
import com.yidianling.course.bean.CouponHintResponseBean
import com.yidianling.course.net.CourseRetrofitUtils
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.functions.Consumer
import kotlinx.android.synthetic.main.coupon_hint_view.view.*

/**
 * @author <a href="https://www.jianshu.com/u/c1e5310dd724">xujian</a>
 * @描述:我的课程优惠码View
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/12/27
 */
class CouponHintView : RelativeLayout{
    private var jumpType : Int = JUMP_TO_COUPON_LIST

    private var mCouponHintCallBack : CouponHintCallBack? = null
    //是否显示
    private var couponHintVisible : Int = View.VISIBLE

    private var couponUrl:String? = null

    companion object {
        /**
         * 跳转类型
         * 0.跳转红包
         */
        const val JUMP_TO_COUPON_LIST          = 0
    }

    constructor(context:Context):super(context){
        initView()
    }

    constructor(context: Context,attributeSet: AttributeSet):super(context,attributeSet){
        initView()
    }

    /**
     * 界面初始化
     */
    private fun initView(){
        View.inflate(context, R.layout.coupon_hint_view,this)
        setOnClickListener {
            when(jumpType){
                JUMP_TO_COUPON_LIST ->{//我的红包
                    if (TextUtils.isEmpty(couponUrl)) {
                        YDLRouterManager.router(IYDLRouterConstant.ROUTER_MINE_REDPACKET)
                    }else {
                        YDLRouterManager.router(couponUrl)
                    }
                }
            }
            visibility = View.GONE
        }
        imgClose.setOnClickListener {
            visibility = View.GONE
        }
    }

    /**
     * 请求红包列表数据
     */
    @SuppressLint("CheckResult")
    fun initData(visible : Int){
        this.couponHintVisible = visible

        CourseRetrofitUtils.getCouponHint(CouponHintParam(0)).compose(RxUtils.resultJavaData())
                .map { it }
                .filter { it != null }
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(Consumer {
                    if (null != it) {
                        setData(it)
                        couponUrl = it.url
                    }
                }, object: ThrowableConsumer() {
                    override fun accept(msg: String) {
                        visibility = View.GONE
                    }
                })
    }
    //设置跳转到我的红包
    fun setCouponList(){
        jumpType = JUMP_TO_COUPON_LIST
    }

    /**
     * 数据赋值
     */
    private fun setData(couponData : CouponHintResponseBean){
        if (TextUtils.isEmpty(couponData.msg)){
            visibility = View.GONE
            return
        }
        //因为数据请求是异步的 会出现 MainActivity设置了隐藏 但是到了这里 依然显示的现象
        visibility = couponHintVisible
        val sb = StringBuffer()
        sb.append(couponData.msg)
        tvMsg.text = sb.toString()
    }

    fun setCloseHide(){
        imgClose.visibility = View.GONE
    }

    fun setRedPacketCallBack(mRedPacketCallBack : CouponHintCallBack){
        this.mCouponHintCallBack = mRedPacketCallBack
    }

    interface CouponHintCallBack{
        fun jumpInfo() //暂未设置跳转
    }
}