package com.yidianling.course.widget

import android.content.Context
import android.text.SpannableString
import android.text.Spanned
import android.text.TextUtils
import android.text.style.AbsoluteSizeSpan
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.yidianling.common.tools.RxImageTool
import com.yidianling.course.R
import com.yidianling.course.bean.CourseCouponBean
import kotlinx.android.synthetic.main.course_view_course_coupon_detail.view.*
import java.lang.Float
import java.math.BigDecimal


/**
 * @author jiucheng
 * @描述:课程优惠券详情页面
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/3/27
 */
class CourseCouponDetailView : LinearLayout {
    constructor(context: Context) : super(context) {
        initView()
    }

    private fun initView() {
        orientation = LinearLayout.HORIZONTAL
        val params = LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, RxImageTool.dp2px(90f))
        params.bottomMargin = RxImageTool.dp2px(10f)
        layoutParams = params
        setBackgroundResource(R.drawable.course_img_course_coupon_detail_bg)
        View.inflate(context, R.layout.course_view_course_coupon_detail, this)
    }


    fun setData(beanCourse: CourseCouponBean, hasReceived: Boolean, event: (toLink: String) -> Unit) {
        if (TextUtils.equals(beanCourse.type, "1")) {//立减
            val amountStr = "¥${beanCourse.amount}"
            val sp = SpannableString(amountStr)
            sp.setSpan(AbsoluteSizeSpan(16, true), 0, 1, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE)
            tv_price.text = sp
        } else {//折扣
            val a1 = BigDecimal(Float.toString(beanCourse.discount.toFloat()))
            val b1 = BigDecimal(Float.toString(10f))
            val result = a1.multiply(b1).toFloat()// 相乘结果
            val discountStr = "${result}折"
            val discountSp = SpannableString(discountStr)
            discountSp.setSpan(AbsoluteSizeSpan(16, true), discountStr.length - 1, discountStr.length, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE)
            tv_price.text = discountSp
        }
        tv_title.text = beanCourse.title
        tv_duration.text = beanCourse.effective
        tv_use_condition.text = beanCourse.rangeCont
        tv_discountCont.text = beanCourse.discountCont
        if (TextUtils.isEmpty(beanCourse.discountCont) && beanCourse.useCondition == "1") {
            tv_discountCont.text = "无限制"
        }

        tv_use.visibility = if (hasReceived) View.VISIBLE else View.GONE
        tv_use.setOnClickListener {
            event(beanCourse.toLink)
        }
    }

    fun setUseVisibility(hasReceived: Boolean) {
        tv_use.visibility = if (hasReceived) View.VISIBLE else View.GONE
    }
}
