package com.yidianling.course.widget

import android.content.Context
import android.os.Bundle
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.ydl.media.audio.utils.PlayProgressUtil
import com.ydl.ydlcommon.base.BaseDialogFragment
import com.ydl.ydlcommon.utils.extend.gone
import com.ydl.ydlcommon.utils.extend.visible
import com.yidianling.common.view.ui.VoicePlayingIcon
import com.yidianling.course.R
import com.yidianling.course.bean.CourseMediaBean
import com.yidianling.course.coursePlay.presenter.IAudioPlayContract

/**
 * 课程目录弹窗
 */
class CourseListDialog : BaseDialogFragment() {

    var mView: IAudioPlayContract.View? = null
    var mPresenter: IAudioPlayContract.Presenter? = null
    var mCurrentPosition = 0
    private var mAdapter: CourseListDialog.CourseListAdapter? = null
    private val mCourseList = mutableListOf<CourseMediaBean>()
    private var mIsBuy = false
    private lateinit var recycler_list: RecyclerView

    override fun getLayoutResourceId(): Int = R.layout.dialog_course_list
    override fun setGravity(): Int = Gravity.BOTTOM

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        context?.let { ctx ->
            recycler_list = view.findViewById(R.id.recycler_list)
            recycler_list.adapter = mAdapter ?: CourseListAdapter(ctx).also { mAdapter = it }
        }
    }

    fun setData(isBuy: Boolean, currentPosition: Int, courseList: List<CourseMediaBean>) {
        mIsBuy = isBuy
        mCurrentPosition = currentPosition
        mCourseList.clear()
        mCourseList.addAll(courseList)
//        mAdapter?.notifyDataSetChanged()
    }

    fun setCurrentPosition(currentPosition: Int) {
        mCurrentPosition = currentPosition
//        mAdapter?.notifyDataSetChanged()
    }

    inner class CourseListAdapter(
        context: Context,
        private val inflater: LayoutInflater = LayoutInflater.from(context)
    ) : RecyclerView.Adapter<CourseListAdapter.CourseListVH>() {

        inner class CourseListVH(view: View) : RecyclerView.ViewHolder(view) {
            var voice_play: VoicePlayingIcon
            var iv_play: ImageView
            var iv_audition: ImageView
            var tv_title: TextView

            init {
                voice_play = view.findViewById(R.id.voice_play)
                iv_play = view.findViewById(R.id.iv_play)
                iv_audition = view.findViewById(R.id.iv_audition)
                tv_title = view.findViewById(R.id.tv_title)
            }
        }

        override fun onCreateViewHolder(p0: ViewGroup, itemType: Int): CourseListVH =
            CourseListVH(inflater.inflate(R.layout.item_course_playlist, p0, false))

        override fun onBindViewHolder(vh: CourseListVH, position: Int) {
            mCourseList.elementAtOrNull(position)?.let { bean ->
                vh.run {
                    if (mCurrentPosition == position) {
                        voice_play.visible()
                        voice_play.start()
                        iv_play.gone()
                    } else {
                        voice_play.gone()
                        voice_play.stop()
                        iv_play.visible()
                        if (mIsBuy) {
                            iv_play.setImageResource(R.drawable.course_play_orange)
                        } else {
                            if (bean.isDemo) {
                                iv_play.setImageResource(R.drawable.course_play_orange)
                            } else {
                                iv_play.setImageResource(R.drawable.course_play_lock)
                            }
                        }
                    }
                    iv_audition.visibility = if (bean.isDemo) View.VISIBLE else View.GONE // 试听标签
                    tv_title.text = bean.title

                    itemView.setOnClickListener {
                        if (mCurrentPosition == position) {
                            dismissAllowingStateLoss()
                            return@setOnClickListener
                        }
                        if (!bean.isDemo && !mIsBuy) {
                            mView?.buyCourseTipDialog()
                        } else {
                            PlayProgressUtil.saveProgress(
                                context,
                                mCourseList.elementAtOrNull(position)?.url,
                                0
                            )
                            mCurrentPosition = position
                            notifyDataSetChanged()
                            mPresenter?.togglePlay(position)
                            dismissAllowingStateLoss()
                        }
                    }
                }
            }
        }

        override fun getItemCount(): Int = mCourseList.size
    }

}
