package com.yidianling.course.widget

import android.annotation.SuppressLint
import android.app.Activity
import android.graphics.Paint
import androidx.cardview.widget.CardView
import android.text.TextUtils
import android.util.Base64
import android.view.View
import com.bumptech.glide.load.engine.DiskCacheStrategy
import com.bumptech.glide.request.RequestOptions
import com.ydl.ydl_image.module.GlideApp
import com.ydl.ydl_image.transform.GlideRoundTopTransform
import com.yidianling.course.R
import com.yidianling.course.bean.PostersShareBean
import kotlinx.android.synthetic.main.course_view_course_poster_template.view.*
import java.util.concurrent.Executors


/**
 * @author jiucheng
 * @描述:课程海报模板
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/8/6
 */
@SuppressLint("ViewConstructor")
class CoursePosterTemplate(var mContext: Activity) : CardView(mContext) {

    init {
        initView()
    }

    /**
     * 界面初始化
     */
    private fun initView() {
//        radius = RxImageTool.dp2px(10f).toFloat()
        View.inflate(context, R.layout.course_view_course_poster_template, this)
    }

    @SuppressLint("SetTextI18n")
    fun setData(bean: PostersShareBean, isDefault: Boolean) {
        setType(isDefault)
        val myOptions = RequestOptions()
                .transform(GlideRoundTopTransform(mContext, 10))

        GlideApp.with(mContext)
                .load(bean.pic)
                .apply(myOptions)
                .disallowHardwareConfig()
                .into(iv_pic)
        tv_title.text = bean.title
        tv_intro.text = bean.desc
        tv_price.text = bean.applyFee
        if (TextUtils.equals("1", bean.isPromotion) || TextUtils.equals("3", bean.isPromotion)) {
            tv_price.text = bean.promotionApplyFee
        }
        tv_original_price.text = "原价" + bean.originalApplyFee
        tv_original_price.paint.flags = Paint.STRIKE_THRU_TEXT_FLAG

        tv_course_num.text = bean.subCourseNum
        tv_view_count.text = bean.readNums

        if (bean.shareUser != null) {
            if (!TextUtils.isEmpty(bean.shareUser!!.nickName)) {
                tv_user_name.text = bean.shareUser!!.nickName
            }
            if (!TextUtils.isEmpty(bean.shareUser!!.head)) {
                GlideApp.with(mContext)
                        .load(bean.shareUser!!.head)
                        .disallowHardwareConfig()
                        .into(iv_head)
            }
        }

        if (!TextUtils.isEmpty(bean.qrCodeByte)) {
            if (bean.qrCodeByte.contains(",")) {
                bean.qrCodeByte = bean.qrCodeByte.split(",")[1]
            }
            Executors.newCachedThreadPool().execute {
                var imageByte = Base64.decode(bean.qrCodeByte, Base64.DEFAULT)
                mContext!!.runOnUiThread {
                    GlideApp.with(this)
                            .load(imageByte)
                            .diskCacheStrategy(DiskCacheStrategy.NONE)
                            .disallowHardwareConfig()
                            .into(iv_qrc_code)
                }
            }
        }
    }

    private fun setType(isDefault: Boolean) {
        root_layout.setBackgroundResource(if (isDefault) R.drawable.course_poster_one else R.drawable.course_poster_two)
        view_line.isEnabled = isDefault
        iv_poster_one.isEnabled = isDefault
        iv_poster_two.isEnabled = isDefault
    }
}
