package com.yidianling.course.widget

import android.annotation.SuppressLint
import android.content.Context
import android.text.TextUtils
import android.util.AttributeSet
import android.view.View
import android.widget.RelativeLayout
import com.ydl.ydl_router.manager.YDLRouterManager
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlcommon.data.http.ThrowableConsumer
import com.ydl.ydlcommon.router.IYDLRouterConstant
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils
import com.yidianling.course.R
import com.yidianling.course.bean.RedListParam
import com.yidianling.course.net.CourseRetrofitUtils
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.functions.Consumer
import kotlinx.android.synthetic.main.course_redpacket_view.view.*

/**
 * @author yuanWai
 * @描述:红包提示View
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/11/27
 */
class CourseRedPacketView : RelativeLayout {
    private var jumpType: Int = JUMP_NOT

    private var mRedPacketCallBack: RedPacketCallBack? = null
    private var onDataRequestFinishedListener: OnDataRequestFinishedListener? = null
    //是否显示
    private var redPacketVisible: Int = View.VISIBLE

    companion object {
        /**
         * 跳转类型
         * 0.不跳转 1.跳转倾诉频道 2.跳转专家详情
         */
        const val JUMP_NOT = 0
        const val JUMP_CONFIDE_HOME = 1
        const val JUMP_EXPERT_INFO = 2
    }

    constructor(context: Context) : super(context) {
        initView()
    }

    constructor(context: Context, attributeSet: AttributeSet) : super(context, attributeSet) {
        initView()
    }

    /**
     * 界面初始化
     */
    private fun initView() {
        View.inflate(context, R.layout.course_redpacket_view, this)
        setOnClickListener {
            when (jumpType) {
                JUMP_NOT -> {//不跳转

                }
                JUMP_CONFIDE_HOME -> {//跳转倾诉频道页
//                    ARouter.getInstance().build("/confide/home").navigation()
                    ActionCountUtils.record("listen_counselor_list_page", "listen_counselor_list_page_visit", "3")
                    YDLRouterManager.router(IYDLRouterConstant.ROUTER_CONFIDE_HOME)
                }
                JUMP_EXPERT_INFO -> {//跳转专家详情页
                    if (null != mRedPacketCallBack) {
                        mRedPacketCallBack!!.jumpExpertInfo()
                    }
                }
            }
            visibility = View.GONE
        }
        imgClose.setOnClickListener {
            visibility = View.GONE
        }
    }

    /**
     * 请求红包列表数据
     */
    @SuppressLint("CheckResult")
    fun initData(visible: Int) {
        this.redPacketVisible = visible
        CourseRetrofitUtils.getCouponMax(RedListParam(3)).compose(RxUtils.resultJavaData())
                .map { it }
                .filter { it != null }
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(Consumer {
                    setData(it)
                }, object : ThrowableConsumer() {
                    override fun accept(msg: String) {
                        visibility = View.GONE
                    }
                })
    }

    //设置不跳转
    fun setNot() {
        jumpType = JUMP_NOT
    }

    //设置跳转倾诉列表首页
    fun setConfide() {
        jumpType = JUMP_CONFIDE_HOME
    }

    //设置跳转专家详情页
    fun setExpertInfo() {
        jumpType = JUMP_EXPERT_INFO
    }

    /**
     * 数据赋值
     */
    private fun setData(couponMax: String) {
        if (TextUtils.isEmpty(couponMax)) {
            visibility = View.GONE
            return
        }
        var max = couponMax.toFloat().toInt()
        visibility = if (max > 0) {
            View.VISIBLE
        } else {
            View.GONE
        }
        //因为数据请求是异步的 会出现 MainActivity设置了隐藏 但是到了这里 依然显示的现象
        visibility = redPacketVisible
        if (max <= 0) {
            visibility = View.GONE
        }
        val sb = StringBuffer()
        sb.append("您有")
                .append(max)
                .append("元的倾诉红包，倾诉享")
        tvMsg.text = sb.toString()

        if (onDataRequestFinishedListener != null) {
            onDataRequestFinishedListener!!.onDataRequestFinishedListener(max)
        }

    }

    fun setCloseHide() {
        imgClose.visibility = View.GONE
    }

    fun setRedPacketCallBack(mRedPacketCallBack: RedPacketCallBack) {
        this.mRedPacketCallBack = mRedPacketCallBack
    }

    interface RedPacketCallBack {
        fun jumpExpertInfo()
    }

    fun setOnDataRequestFinishedListener(onDataRequestFinishedListener: OnDataRequestFinishedListener) {
        this.onDataRequestFinishedListener = onDataRequestFinishedListener
    }

    /**
     * 数据请求完成回调
     */
    interface OnDataRequestFinishedListener {
        fun onDataRequestFinishedListener(max: Int)
    }

}