package com.yidianling.dynamic.adapter;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.yidianling.dynamic.R;

import java.util.List;

/**
 * Created by xiongyu on 2017/3/14.
 */

public class DialogListAdapter extends RecyclerView.Adapter<DialogListViewHolder> {
    protected Context mContext;
    protected List<String> mDatas;
    protected LayoutInflater mInflater;
    protected int itemTextColor;
    public interface OnItemClickLister {
        void onItemClick(View view, int position);

        void onItemLongClick(View view, int position);
    }

    private OnItemClickLister mOnItemClickLister;

    public void setOnItemClickLister(OnItemClickLister lister) {
        this.mOnItemClickLister = lister;
    }

    public DialogListAdapter(List<String> mDatas, int itemTextColor,Context mContext) {
        this.mContext = mContext;
        this.mDatas = mDatas;
        this.itemTextColor=itemTextColor;
        mInflater = LayoutInflater.from(mContext);
    }

    @Override
    public DialogListViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view= mInflater.inflate(R.layout.dynamic_item_dialog_list,parent,false);
        DialogListViewHolder viewHolder= new DialogListViewHolder(view);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(DialogListViewHolder holder, int position) {
        String txt=mDatas.get(position);
        if((0 != itemTextColor)){
            holder.item_dialog_tv.setTextColor(itemTextColor);
        }
        holder.item_dialog_tv.setText(txt);
        setUpItemEvent(holder);
    }

    @Override
    public int getItemCount() {
        return mDatas.size();
    }
    /**
     * 添加股据到指定位置
     * @param pos 数据添加的位置
     * @param obj 数据
     */
    public  void addData(int pos,String obj){
        mDatas.add(obj);
        notifyItemInserted(pos);
    }

    /**
     * 删除股票到指定位置
     * @param pos
     */
    public void deleteData(int pos){
        mDatas.remove(pos);
        notifyItemRemoved(pos);
    }

    /**
     * 给item添加监听
     * @param holder
     */
    protected  void setUpItemEvent(final DialogListViewHolder holder){
        if(mOnItemClickLister!=null){
            holder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition=holder.getLayoutPosition();
                    mOnItemClickLister.onItemClick(holder.itemView,layoutPosition);

                }
            });
            holder.itemView.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View v) {
                    int layoutPosition=holder.getLayoutPosition();
                    mOnItemClickLister.onItemLongClick(holder.itemView,layoutPosition);
                    return false;
                }
            });
        }
    }
}

class DialogListViewHolder extends RecyclerView.ViewHolder{
    TextView item_dialog_tv;
    public DialogListViewHolder(View itemView) {
        super(itemView);
        item_dialog_tv=(TextView)itemView.findViewById(R.id.item_dialog_tv);
    }
}