package com.yidianling.dynamic.adapter;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.ydl.ydl_image.module.GlideApp;
import com.ydl.ydl_image.transform.CropSquareTransformation;
import com.yidianling.dynamic.R;
import com.yidianling.dynamic.model.RecommendTopic;
import com.ydl.ydlcommon.view.widgets.RoundImageView;

import java.util.List;

/**
 * 推荐话题适配器
 * Created by xiongyu on 2017/3/14.
 */

public class RecommendTopicAdapter extends RecyclerView.Adapter<RecommendTopicViewHolder> {
    protected Context mContext;
    protected List<RecommendTopic> mDatas;
    protected LayoutInflater mInflater;
    public interface OnItemClickLister {
        void onItemClick(View view, int position);
    }

    private OnItemClickLister mOnItemClickLister;

    public void setOnItemClickLister(OnItemClickLister lister) {
        this.mOnItemClickLister = lister;
    }

    public RecommendTopicAdapter(List<RecommendTopic> mDatas, Context mContext) {
        this.mContext = mContext;
        this.mDatas = mDatas;
        mInflater = LayoutInflater.from(mContext);
    }

    @Override
    public RecommendTopicViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view= mInflater.inflate(R.layout.dynamic_item_recommend_topic,parent,false);
        RecommendTopicViewHolder viewHolder= new RecommendTopicViewHolder(view);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(RecommendTopicViewHolder holder, int position) {
//        holder.item_recommend_topic_rel.getBackground().setAlpha(120);
        RecommendTopic recommendTopic=mDatas.get(position);
        String img_url=recommendTopic.getImg_bg_url();
        String topic_title=recommendTopic.getTopic_title();
        GlideApp.with(mContext)
                .load(img_url)
                .error(R.drawable.dynamic_default_img)
                .transform(new CropSquareTransformation(mContext))//裁剪正方形
                .override(270, 150)
                .centerCrop()
                .into(holder.topic_iv);
        holder.topic_title_tv.setText(topic_title);
        setUpItemEvent(holder);
    }

    @Override
    public int getItemCount() {
        return mDatas.size();
    }
    /**
     * 添加股据到指定位置
     * @param pos 数据添加的位置
     * @param recommendtopic 数据
     */
    public  void addData(int pos,RecommendTopic recommendtopic){
        mDatas.add(recommendtopic);
        notifyItemInserted(pos);
    }

    /**
     * 删除股票到指定位置
     * @param pos
     */
    public void deleteData(int pos){
        mDatas.remove(pos);
        notifyItemRemoved(pos);
    }

    /**
     * 给item添加监听
     * @param holder
     */
    protected  void setUpItemEvent(final RecommendTopicViewHolder holder){
        if(mOnItemClickLister!=null){
            holder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition=holder.getLayoutPosition();
                    mOnItemClickLister.onItemClick(holder.itemView,layoutPosition);

                }
            });
        }
    }
}

class RecommendTopicViewHolder extends RecyclerView.ViewHolder{
    RoundImageView topic_iv;
    TextView topic_title_tv;
//    RelativeLayout item_recommend_topic_rel;
    public RecommendTopicViewHolder(View itemView) {
        super(itemView);
//        item_recommend_topic_rel=(RelativeLayout) itemView.findViewById(item_recommend_topic_rel);
        topic_iv=(RoundImageView)itemView.findViewById(R.id.item_recommend_topic_iv);
        topic_title_tv=(TextView)itemView.findViewById(R.id.item_recommend_topic_tv);
    }
}