package com.yidianling.dynamic.adapter;

import android.content.Context;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import android.text.style.ImageSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.ydl.ydl_image.module.GlideApp;
import com.yidianling.dynamic.R;
import com.yidianling.dynamic.common.net.DynamicApiUtils;
import com.yidianling.dynamic.common.view.WrapGridLayoutManager;
import com.yidianling.dynamic.model.Command;
import com.ydl.ydlcommon.ui.ParcelableImage;
import com.yidianling.dynamic.model.RecommendedDiscuss;
import com.yidianling.dynamic.model.RecommendedTrend;
import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;;
import com.ydl.ydlcommon.utils.StringUtils;
import com.ydl.ydlcommon.utils.MoonUtil;
import com.ydl.ydlcommon.utils.Utils;
import com.ydl.ydlcommon.view.WrapContentLinearLayoutManager;

import org.json.JSONException;

import java.util.ArrayList;
import java.util.List;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;


/**
 * 动态列表Adapter
 * Created by xiongyu on 2017/3/14.
 */

public class RecommendTrendAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    protected Context mContext;
    protected List<RecommendedTrend> mDatas;
    protected LayoutInflater mInflater;
    private RecommendDicussAdapter dicussAdapter;//动态评论Adapter

    private final static int TYPE_ONE = 0;
    private final static int TYPE_TWO = 1;
    private final static int TYPE_LODE_MORE = 2;
    private static final int TYPE_THREE = 3;

    public interface OnItemClickLister {
        void onItemClick(View view, TextView textView, int position);
    }

    public interface OnZanClickLister {
        void onClick(ImageView textView, TextView view, int position) throws JSONException;
    }

    public interface OnHeadClickLister {
        void onClick(View view, int position);
    }

    public interface OnImgClickLister {
        void onImgClick(View view, TextView textView, int mposition, int position);
    }

    public interface OnDiscussClickLister {
        void onDicussClick(View view, TextView textView, int position);
    }

    public interface OnAdClickLister {
        void onClick(View view, TextView textView, int position);
    }

    private OnItemClickLister mOnItemClickLister;
    private OnZanClickLister mOnZanClickLister;
    private OnHeadClickLister mOnHeadClickLister;
    private OnImgClickLister mOnImgClickLister;
    private OnDiscussClickLister mOnDiscussClickLister;
    private OnAdClickLister mOnAdClickLister;

    public void setOnItemClickLister(OnItemClickLister lister) {
        this.mOnItemClickLister = lister;
    }

    public void setmOnZanClickLister(OnZanClickLister lister) {
        this.mOnZanClickLister = lister;
    }

    public void setmDiscussClickLister(OnDiscussClickLister lister) {
        this.mOnDiscussClickLister = lister;
    }

    public void setmOnHeadClickLister(OnHeadClickLister lister) {
        this.mOnHeadClickLister = lister;
    }

    public void setOnImgClickLister(OnImgClickLister lister) {
        this.mOnImgClickLister = lister;
    }

    public void setOnAdClickLister(OnAdClickLister lister) {
        this.mOnAdClickLister = lister;
    }

    public RecommendTrendAdapter(List<RecommendedTrend> mDatas, Context mContext) {
        this.mContext = mContext;
        this.mDatas = mDatas;
        mInflater = LayoutInflater.from(mContext);
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view;
        RecyclerView.ViewHolder holder = null;
        switch (viewType) {
            case TYPE_ONE:
                view = mInflater.inflate(R.layout.dynamic_item_recommend_trend, parent, false);
                holder = new RecommendTrendViewHolder(view);
                break;

            case TYPE_TWO:
                view = mInflater.inflate(R.layout.dynamic_item_recommend_trend_ad, parent, false);
                holder = new RecommendTrendAdViewHolder(view);
                break;

            case TYPE_LODE_MORE:
                view = mInflater.inflate(R.layout.dynamic_item_trend_load_more, parent, false);
                holder = new TrendLoadMoreViewHolder(view);
                break;
            case TYPE_THREE://广告
                view = mInflater.inflate(R.layout.dynamic_item_recommend_trend_ad2, parent, false);
                holder = new RecommendTrendAdViewHolder2(view);
                break;
        }
        return holder;
    }


    @Override
    public int getItemViewType(int position) {

        RecommendedTrend trend = mDatas.get(position);
        if (trend.getIsAd() == 1) {
            return TYPE_THREE;
        } else if ("4".equals(trend.getTrend_type())) {//广告
            return TYPE_TWO;
        } else if ("load_more".equals(trend.getTrend_type())) {
            return TYPE_LODE_MORE;
        } else {//普通
            return TYPE_ONE;
        }
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        RecommendedTrend recommendedTrend = mDatas.get(position);
        String trend_id = recommendedTrend.getTrend_id();
        String user_name = recommendedTrend.getUser_name();
        String up_flag = recommendedTrend.getUp_flag();
        String trend_content = "" + recommendedTrend.getTrend_content();
        String trend_topic = "#" + recommendedTrend.getTrend_topic() + "#";
        String user_gender = recommendedTrend.getUser_gender();
        String user_head = recommendedTrend.getUser_head();
        String souce = recommendedTrend.getSouce();
        String trend_title = recommendedTrend.getTrend_title();
        String time = recommendedTrend.getPublish_time();
        String read_num = "阅读 " + recommendedTrend.getRead_num();
        String is_zan = recommendedTrend.getIs_zan();

        switch (getItemViewType(position)) {
            case TYPE_ONE:
                final RecommendTrendViewHolder holderOne = (RecommendTrendViewHolder) holder;
                WrapContentLinearLayoutManager linearLayoutManager1 = new WrapContentLinearLayoutManager(mContext, WrapContentLinearLayoutManager.VERTICAL, false);
                holderOne.trend_discuss_rcv.setLayoutManager(linearLayoutManager1);
                List<RecommendedDiscuss> recommendedDiscusses = new ArrayList<>();
                recommendedDiscusses.clear();
                recommendedDiscusses = recommendedTrend.getTrednDiscuss();
                int DiscussNum = recommendedTrend.getDiscussNum();
                if ("2".equals(up_flag)) {
                    holderOne.trend_title_tv.setText(Utils.textValueOf(R.drawable.dynamic_newsfeed_icon_zhiding, trend_title));
                } else {
                    holderOne.trend_title_tv.setText(trend_title);
                }
                holderOne.user_name_tv.setText(user_name);
                holderOne.trend_souce_tv.setText(" - " + souce);

                try {
                    GlideApp.with(mContext)
                            .load(user_head)
                            .circleCrop()
                            .placeholder(R.drawable.dynamic_head_place_hold_pic)
                            .error(R.drawable.dynamic_head_place_hold_pic)
                            .into(holderOne.user_head_iv);
                } catch (Exception e) {
                    e.printStackTrace();
                }

                if ("1".equals(user_gender)) {
                    holderOne.user_gender_iv.setImageResource(R.drawable.dynamic_male);
                } else if ("2".equals(user_gender)) {
                    holderOne.user_gender_iv.setImageResource(R.drawable.dynamic_female);
                }

                holderOne.time_tv.setText(time);

                if (trend_content.length() > 70) {
                    trend_content = StringUtils.CustomEmojiSub(trend_content);
                    MoonUtil.SetTrendContent(mContext, holderOne.trend_content_tv, trend_content + "", "", "...查看全部", ImageSpan.ALIGN_BOTTOM);
                } else {
                    MoonUtil.SetTrendContent(mContext, holderOne.trend_content_tv, trend_content, "", "", ImageSpan.ALIGN_BOTTOM);
                }

                holderOne.text_trend.setText(trend_topic);

//                trend_content = "<font color='#3f95d7' charset='utf-8'>" + trend_topic + "</font>" + trend_content;
//                if (trend_content.length() > 140) {
//                    trend_content = trend_content + "..." + "<font color='#3f95d7' charset='utf-8'>全文</font>";
//                }
//                holderOne.trend_content_tv.setText(Html.fromHtml(trend_content));
                holderOne.trend_readed_tv.setText(read_num);
//                holderOne.zannum_tv.setText(zan_num);

                try {
                    holderOne.text_zan_num.setText(recommendedTrend.getZan_num());
                } catch (NumberFormatException e) {
                    e.printStackTrace();
                }


                if ("1".equals(is_zan)) {//赞
                    holderOne.item_recommend_trend_zan_iv.setImageDrawable(ContextCompat.getDrawable(mContext, R.drawable.dynamic_newsfeed_like_sel));
//                    holderOne.text_zan_num.setCompoundDrawablesWithIntrinsicBounds(ContextCompat.getDrawable(mContext,R.mipmap.newsfeed_like_sel),null,null,null);
                } else {//未赞
                    holderOne.item_recommend_trend_zan_iv.setImageDrawable(ContextCompat.getDrawable(mContext, R.drawable.dynamic_newsfeed_like));
//                    holderOne.text_zan_num.setCompoundDrawablesWithIntrinsicBounds(ContextCompat.getDrawable(mContext,R.mipmap.newsfeed_like),null,null,null);
                }

                List<ParcelableImage> parcelableImages = new ArrayList<ParcelableImage>();
                List<ParcelableImage> recommendTrendBigImages = new ArrayList<ParcelableImage>();

                parcelableImages.clear();
                recommendTrendBigImages.clear();
                recommendTrendBigImages = recommendedTrend.getTrendBigImages();
                parcelableImages = recommendedTrend.getTrendImages();

                dicussAdapter = new RecommendDicussAdapter(recommendedDiscusses, mContext);
                //图片
                if (parcelableImages.size() > 3) {
                    holderOne.trend_img_rel.setVisibility(View.VISIBLE);
                    holderOne.trend_img_num_tv.setVisibility(View.VISIBLE);
                    holderOne.trend_img_num_tv.setText("共" + parcelableImages.size() + "张");
                    holderOne.trend_img_rcv.setLayoutManager(new WrapGridLayoutManager(mContext, 3));

                } else if (parcelableImages.size() == 3) {
                    holderOne.trend_img_rel.setVisibility(View.VISIBLE);
                    holderOne.trend_img_num_tv.setVisibility(View.GONE);

                    holderOne.trend_img_rcv.setLayoutManager(new WrapGridLayoutManager(mContext, 3));
                } else if (parcelableImages.size() == 2) {
                    holderOne.trend_img_rel.setVisibility(View.VISIBLE);
                    holderOne.trend_img_num_tv.setVisibility(View.GONE);
                    holderOne.trend_img_rcv.setLayoutManager(new WrapGridLayoutManager(mContext, 2));
                } else if (parcelableImages.size() == 1) {
                    holderOne.trend_img_rel.setVisibility(View.VISIBLE);
                    holderOne.trend_img_num_tv.setVisibility(View.GONE);
                    ParcelableImage trendImanull = new ParcelableImage("no");
                    parcelableImages.add(trendImanull);
                    holderOne.trend_img_rcv.setLayoutManager(new WrapGridLayoutManager(mContext, 2));
                } else {
                    holderOne.trend_img_num_tv.setVisibility(View.GONE);
                    holderOne.trend_img_rel.setVisibility(View.GONE);
                    holderOne.trend_img_rcv.setLayoutManager(new WrapGridLayoutManager(mContext, 1));
                }
                RecommendTrendImgAdapter trendImgAdapter = new RecommendTrendImgAdapter(parcelableImages, recommendTrendBigImages, mContext, trend_id);
                trendImgAdapter.updateDate(parcelableImages, recommendTrendBigImages);
                holderOne.trend_img_rcv.setAdapter(trendImgAdapter);


                //评论
                if (DiscussNum > 0) {
                    holderOne.trend_discuss_rel.setVisibility(View.VISIBLE);

                    if (DiscussNum > 5) {
                        holderOne.trend_discuss_num_tv.setText("全部" + DiscussNum + "条评论");
                    } else {
                        holderOne.trend_discuss_num_tv.setVisibility(View.GONE);
                    }

                    holderOne.text_talk_num.setText(DiscussNum + "");

                    holderOne.trend_discuss_rcv.setAdapter(dicussAdapter);

                } else {
                    holderOne.trend_discuss_rel.setVisibility(View.GONE);
                    holderOne.text_talk_num.setText("评论");
                }
                setUpItemEvent(holderOne, dicussAdapter);
                setImgEvent(holderOne, trendImgAdapter);
                setDiscussUpEvent(holderOne);
                setZanUpEvent(holderOne);
                setHeadUpEvent(holderOne);
                break;
            case TYPE_TWO:
                final RecommendTrendAdViewHolder holdertwo = (RecommendTrendAdViewHolder) holder;
                WrapContentLinearLayoutManager linearLayoutManager2 = new WrapContentLinearLayoutManager(mContext, WrapContentLinearLayoutManager.VERTICAL, false);
                holdertwo.trend_discuss_rcv.setLayoutManager(linearLayoutManager2);
                List<RecommendedDiscuss> recommendedDiscusses2 = new ArrayList<RecommendedDiscuss>();

                recommendedDiscusses2.clear();
                recommendedDiscusses2 = recommendedTrend.getTrednDiscuss();
                dicussAdapter = new RecommendDicussAdapter(recommendedDiscusses2, mContext);
                int DiscussNum1 = recommendedTrend.getDiscussNum();
                if ("2".equals(up_flag)) {
                    holdertwo.trend_title_tv.setText(Utils.textValueOf(R.drawable.dynamic_newsfeed_icon_zhiding, trend_title));
                } else {
                    holdertwo.trend_title_tv.setText(trend_title);
                }
                holdertwo.user_name_tv.setText(user_name);
                holdertwo.trend_souce_tv.setText(" - " + souce);

                GlideApp.with(mContext)
                        .load(user_head)
                        .circleCrop()
                        .placeholder(R.drawable.dynamic_default_img)
                        .error(R.drawable.dynamic_default_img)
                        .into(holdertwo.user_head_iv);

                if ("1".equals(user_gender)) {
                    holdertwo.user_gender_iv.setImageResource(R.drawable.dynamic_male);
                } else if ("2".equals(user_gender)) {
                    holdertwo.user_gender_iv.setImageResource(R.drawable.dynamic_female);
                }

                holdertwo.time_tv.setText(time);
                if (trend_content.length() > 100) {
                    trend_content = StringUtils.CustomEmojiSub(trend_content);
                    MoonUtil.SetTrendContent(mContext, holdertwo.trend_content_tv, trend_content + "", trend_topic, "...查看全部", ImageSpan.ALIGN_BOTTOM);
                } else {
                    MoonUtil.SetTrendContent(mContext, holdertwo.trend_content_tv, trend_content, trend_topic, "", ImageSpan.ALIGN_BOTTOM);
                }
//                trend_content = "<font color='#3f95d7' charset='utf-8'>" + trend_topic + "</font>" + trend_content;
//                if (trend_content.length() > 140) {
//                    trend_content = trend_content + "..." + "<font color='#3f95d7' charset='utf-8'>全文</font>";
//                }
//                holdertwo.trend_content_tv.setText(Html.fromHtml(trend_content));

                holdertwo.trend_readed_tv.setText(read_num);

//                holdertwo.zannum_tv.setText(zan_num);
                try {
                    holdertwo.text_zan_num.setText(recommendedTrend.getZan_num());
                } catch (NumberFormatException e) {
                    e.printStackTrace();
                }

                if ("1".equals(is_zan)) {//赞
                    holdertwo.item_recommend_trend_zan_iv.setImageDrawable(ContextCompat.getDrawable(mContext, R.drawable.dynamic_newsfeed_like_sel));
//                    holdertwo.text_zan_num.setCompoundDrawablesWithIntrinsicBounds(ContextCompat.getDrawable(mContext,R.mipmap.newsfeed_like_sel),null,null,null);
                } else {//未赞
                    holdertwo.item_recommend_trend_zan_iv.setImageDrawable(ContextCompat.getDrawable(mContext, R.drawable.dynamic_newsfeed_like));
//                    holdertwo.text_zan_num.setCompoundDrawablesWithIntrinsicBounds(ContextCompat.getDrawable(mContext,R.mipmap.newsfeed_like),null,null,null);
                }
                //评论
                if (DiscussNum1 > 0) {
                    holdertwo.trend_discuss_rel.setVisibility(View.VISIBLE);

                    if (DiscussNum1 > 5) {
                        holdertwo.trend_discuss_num_tv.setText("全部" + DiscussNum1 + "条评论");
                    } else {
                        holdertwo.trend_discuss_num_tv.setVisibility(View.GONE);
                    }

                    holdertwo.text_talk_num.setText(DiscussNum1 + "");
                    holdertwo.trend_discuss_rcv.setAdapter(dicussAdapter);

                } else {
                    holdertwo.trend_discuss_rel.setVisibility(View.GONE);
                    holdertwo.text_talk_num.setText("评论");
                }

                //广告
                String ad_img = recommendedTrend.getAd_img();
                String jump_title = recommendedTrend.getJump_title();

                GlideApp.with(mContext)
                        .load(ad_img)
                        .placeholder(R.drawable.dynamic_default_img)
                        .error(R.drawable.dynamic_default_img)
                        .into(holdertwo.trend_ad_iv);
                holdertwo.trend_ad_tv.setText(jump_title);

                setAdEvent(holdertwo);
                setDiscussUpEvent(holdertwo);
                setUpItemEvent(holdertwo, dicussAdapter);
                setZanUpEvent(holdertwo);
                setHeadUpEvent(holdertwo);
                break;
            case TYPE_LODE_MORE:
                final TrendLoadMoreViewHolder holderloadmore = (TrendLoadMoreViewHolder) holder;
                String load_more_hint = recommendedTrend.getLoadMoreHint();
                holderloadmore.load_more_tv.setText(load_more_hint);
                setUpItemEvent(holderloadmore);
                break;
            case TYPE_THREE:
                final RecommendTrendAdViewHolder2 holderThree = (RecommendTrendAdViewHolder2) holder;
                holderThree.itemRecommendTrendUserNameTv.setText(user_name);
                holderThree.itemRecommendTrendTitleTv.setText(trend_title);
                GlideApp.with(mContext)
                        .load(user_head)
                        .circleCrop()
                        .placeholder(R.drawable.dynamic_head_place_hold_pic)
                        .error(R.drawable.dynamic_head_place_hold_pic)
                        .into(holderThree.itemRecommendTrendUserHeadIv);

                if ("1".equals(user_gender)) {
                    holderThree.itemRecommendTrendUserGenderIv.setImageResource(R.drawable.dynamic_male);
                } else if ("2".equals(user_gender)) {
                    holderThree.itemRecommendTrendUserGenderIv.setImageResource(R.drawable.dynamic_female);
                }

                holderThree.itemRecommendTrendTimeTv.setText(time);

                if (trend_content.length() > 70) {
                    trend_content = StringUtils.CustomEmojiSub(trend_content);
                    MoonUtil.SetTrendContent(mContext, holderThree.itemRecommendTrendContentTv, trend_content + "", "", "...查看全部", ImageSpan.ALIGN_BOTTOM);
                } else {
                    MoonUtil.SetTrendContent(mContext, holderThree.itemRecommendTrendContentTv, trend_content, "", "", ImageSpan.ALIGN_BOTTOM);
                }
                holderThree.itemRecommendTrendReadedTv.setText(read_num);
                GlideApp.with(mContext)
                        .load(recommendedTrend.getAdImg())
                        .placeholder(R.drawable.dynamic_default_img)
                        .into(holderThree.ivAdImg);
                holderThree.itemView.setOnClickListener(v -> {
                    H5Params params = new H5Params(recommendedTrend.getUrl(), null, recommendedTrend.getShare());
                    NewH5Activity.start(mContext, params);
                    DynamicApiUtils.adClickCount(new Command.AdClickCount(recommendedTrend.getFocId()))
                            .subscribeOn(Schedulers.io())
                            .observeOn(AndroidSchedulers.mainThread())
                            .subscribe(objectBaseResponse -> {

                            }, throwable -> {

                            });
                });
                if (mOnHeadClickLister != null) {
                    holderThree.itemRecommendTrendUserHeadIv.setOnClickListener(v -> {
                        int layoutPosition = holder.getLayoutPosition();
                        mOnHeadClickLister.onClick(holderThree.itemRecommendTrendUserHeadIv, layoutPosition);

                    });
                }
                break;
        }


    }

    @Override
    public int getItemCount() {
        return mDatas.size();
    }

    /**
     * 添加数据到指定位置
     *
     * @param pos 数据添加的位置
     * @param obj 数据
     */
    public void addData(int pos, RecommendedTrend obj) {
        mDatas.add(obj);
        notifyItemInserted(pos);
    }

    public void addDatas(int pos, List<RecommendedTrend> mDatasns) {
        if (mDatasns != null && mDatasns.size() > 0) {
            mDatasns.addAll(mDatasns);
            notifyItemRangeChanged(pos, mDatasns.size());
        }
//        notifyItemInserted(pos);
    }

    public void addDatas(List<RecommendedTrend> mDatasns) {
        if (mDatasns != null && mDatasns.size() > 0) {
            mDatasns.addAll(mDatasns);
            notifyDataSetChanged();
        }
//        notifyItemInserted(pos);
    }

    public List<RecommendedTrend> getmDatas() {
        return mDatas;
    }

    public void updateDate(List<RecommendedTrend> mDatasn) {
        this.mDatas = mDatasn;
        notifyDataSetChanged();
    }

    public void updateDisscussDate(List<RecommendedDiscuss> mDatasn) {
        dicussAdapter.updateDate(mDatasn);
    }


    /**
     * 给item添加监听
     *
     * @param holder
     */
    protected void setUpItemEvent(final TrendLoadMoreViewHolder holder) {
        if (mOnItemClickLister != null) {
            holder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition = holder.getLayoutPosition();
                    mOnItemClickLister.onItemClick(holder.itemView, null, layoutPosition);

                }
            });

        }
    }

    /**
     * 给动态中图片添加监听
     */
    protected void setImgEvent(final RecommendTrendViewHolder holder, RecommendTrendImgAdapter adapter) {
        if (mOnImgClickLister != null) {

            adapter.setOnItemClickLister(new RecommendTrendImgAdapter.OnItemClickLister() {
                @Override
                public void onItemClick(View view, int position) {
                    int layoutPosition = holder.getLayoutPosition();
                    mOnImgClickLister.onImgClick(view, holder.trend_readed_tv, layoutPosition, position);
                }
            });
        }
    }


    /**
     * 给item添加监听
     *
     * @param holder
     */
    protected void setUpItemEvent(final RecommendTrendViewHolder holder, RecommendDicussAdapter adapter) {
        if (mOnItemClickLister != null) {
            holder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition = holder.getLayoutPosition();
                    mOnItemClickLister.onItemClick(holder.itemView, holder.trend_readed_tv, layoutPosition);

                }
            });
            adapter.setOnItemClickLister(new RecommendDicussAdapter.OnItemClickLister() {
                @Override
                public void onItemClick(View view, int position) {
                    int layoutPosition = holder.getLayoutPosition();
                    mOnItemClickLister.onItemClick(view, holder.trend_readed_tv, layoutPosition);
                }
            });
        }
    }


    /**
     * 给item添加监听
     *
     * @param holder
     */
    protected void setUpItemEvent(final RecommendTrendAdViewHolder holder, RecommendDicussAdapter adapter) {
        if (mOnItemClickLister != null) {
            holder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition = holder.getLayoutPosition();
                    mOnItemClickLister.onItemClick(holder.itemView, holder.trend_readed_tv, layoutPosition);

                }
            });

            adapter.setOnItemClickLister(new RecommendDicussAdapter.OnItemClickLister() {
                @Override
                public void onItemClick(View view, int position) {
                    int layoutPosition = holder.getLayoutPosition();
                    mOnItemClickLister.onItemClick(view, holder.trend_readed_tv, layoutPosition);
                }
            });

        }
    }

    /**
     * 给广告item中的广告模块添加监听
     *
     * @param holder
     */
    protected void setAdEvent(final RecommendTrendAdViewHolder holder) {
        if (mOnAdClickLister != null) {
            holder.trend_ad_rel.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition = holder.getLayoutPosition();
                    mOnAdClickLister.onClick(holder.trend_ad_rel, holder.trend_readed_tv, layoutPosition);
                }
            });

        }
    }

    /**
     * 给单个组件（评论按钮）添加监听
     *
     * @param holder
     */
    protected void setDiscussUpEvent(final RecommendTrendViewHolder holder) {
        if (mOnDiscussClickLister != null) {
            holder.item_recommend_trend_discuss_iv.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition = holder.getLayoutPosition();
                    mOnDiscussClickLister.onDicussClick(v, holder.trend_readed_tv, layoutPosition);

                }
            });
        }
    }

    /**
     * 给单个组件（评论按钮）添加监听
     *
     * @param holder
     */
    protected void setDiscussUpEvent(final RecommendTrendAdViewHolder holder) {
        if (mOnDiscussClickLister != null) {
            holder.item_recommend_trend_discuss_iv.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition = holder.getLayoutPosition();
                    mOnDiscussClickLister.onDicussClick(v, holder.trend_readed_tv, layoutPosition);

                }
            });
        }
    }

    /**
     * 给单个组件（赞）添加监听
     *
     * @param holder
     */
    protected void setZanUpEvent(final RecommendTrendViewHolder holder) {
        if (mOnZanClickLister != null) {
            holder.item_recommend_trend_zan_iv.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition = holder.getLayoutPosition();
                    try {
                        mOnZanClickLister.onClick(holder.item_recommend_trend_zan_iv, holder.text_zan_num, layoutPosition);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }

                }
            });
        }
    }

    /**
     * 给单个组件（赞）添加监听
     *
     * @param holder
     */
    protected void setZanUpEvent(final RecommendTrendAdViewHolder holder) {
        if (mOnZanClickLister != null) {
            holder.item_recommend_trend_zan_iv.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition = holder.getLayoutPosition();
                    try {
                        mOnZanClickLister.onClick(holder.item_recommend_trend_zan_iv, holder.text_zan_num, layoutPosition);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }

                }
            });
        }
    }

    /**
     * 给单个组件（头像）添加监听
     *
     * @param holder
     */
    protected void setHeadUpEvent(final RecommendTrendViewHolder holder) {
        if (mOnHeadClickLister != null) {
            holder.user_head_iv.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition = holder.getLayoutPosition();
                    mOnHeadClickLister.onClick(holder.user_head_iv, layoutPosition);

                }
            });
        }
    }

    /**
     * 给单个组件（头像）添加监听
     *
     * @param holder
     */
    protected void setHeadUpEvent(final RecommendTrendAdViewHolder holder) {
        if (mOnHeadClickLister != null) {
            holder.user_head_iv.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition = holder.getLayoutPosition();
                    mOnHeadClickLister.onClick(holder.user_head_iv, layoutPosition);

                }
            });
        }
    }
}

/**
 * 普通动态
 */
class RecommendTrendViewHolder extends RecyclerView.ViewHolder {
    RelativeLayout trend_user_rel, trend_img_rel, trend_discuss_rel;
    ImageView user_head_iv, user_gender_iv;
    TextView user_name_tv, time_tv, trend_title_tv, trend_content_tv, trend_readed_tv, zannum_tv, trend_img_num_tv, trend_discuss_num_tv, trend_souce_tv;
    RecyclerView trend_img_rcv;
    RecyclerView trend_discuss_rcv;

    TextView text_trend;
    ImageView item_recommend_trend_discuss_iv, item_recommend_trend_zan_iv;

    TextView text_zan_num, text_talk_num;//点赞数和评论数

    public RecommendTrendViewHolder(View itemView) {
        super(itemView);
        trend_user_rel = (RelativeLayout) itemView.findViewById(R.id.item_recommend_trend_user_rel);
        user_head_iv = (ImageView) itemView.findViewById(R.id.item_recommend_trend_user_head_iv);
        user_gender_iv = (ImageView) itemView.findViewById(R.id.item_recommend_trend_user_gender_iv);
        user_name_tv = (TextView) itemView.findViewById(R.id.item_recommend_trend_user_name_tv);
        time_tv = (TextView) itemView.findViewById(R.id.item_recommend_trend_time_tv);
        trend_title_tv = (TextView) itemView.findViewById(R.id.item_recommend_trend_title_tv);
        trend_content_tv = (TextView) itemView.findViewById(R.id.item_recommend_trend_content_tv);
        trend_img_rcv = (RecyclerView) itemView.findViewById(R.id.item_recommend_trend_img_rcv);
        trend_discuss_rcv = (RecyclerView) itemView.findViewById(R.id.item_recommend_trend_discuss_rcv);
        trend_readed_tv = (TextView) itemView.findViewById(R.id.item_recommend_trend_readed_tv);
        zannum_tv = (TextView) itemView.findViewById(R.id.item_recommend_trend_zannum_tv);
        text_talk_num = (TextView) itemView.findViewById(R.id.text_talk_num);
        text_zan_num = (TextView) itemView.findViewById(R.id.text_zan_num);
        trend_discuss_rel = (RelativeLayout) itemView.findViewById(R.id.item_recommend_trend_discuss_rel);
        trend_img_rel = (RelativeLayout) itemView.findViewById(R.id.item_recommend_trend_img_rel);
        trend_img_num_tv = (TextView) itemView.findViewById(R.id.item_recommend_trend_img_num_tv);
        trend_discuss_num_tv = (TextView) itemView.findViewById(R.id.item_recommend_trend_discuss_num_tv);
        trend_souce_tv = (TextView) itemView.findViewById(R.id.item_recommend_trend_souce_tv);

        text_trend = (TextView) itemView.findViewById(R.id.text_trend);
        item_recommend_trend_zan_iv = (ImageView) itemView.findViewById(R.id.item_recommend_trend_zan_iv);
        item_recommend_trend_discuss_iv = (ImageView) itemView.findViewById(R.id.item_recommend_trend_discuss_iv);
    }
}


/**
 * 广告
 */
class RecommendTrendAdViewHolder extends RecyclerView.ViewHolder {
    RelativeLayout trend_user_rel, trend_img_rel, trend_discuss_rel;
    ImageView user_head_iv, user_gender_iv;
    TextView user_name_tv, time_tv, trend_title_tv, trend_content_tv, trend_readed_tv, zannum_tv, trend_img_num_tv, trend_discuss_num_tv, trend_souce_tv;
    RelativeLayout trend_ad_rel;
    ImageView trend_ad_iv;
    TextView trend_ad_tv;
    RecyclerView trend_discuss_rcv;
    TextView text_trend;

    ImageView item_recommend_trend_discuss_iv, item_recommend_trend_zan_iv;

    TextView text_zan_num, text_talk_num;//点赞数和评论数

    public RecommendTrendAdViewHolder(View itemView) {
        super(itemView);
        trend_user_rel = (RelativeLayout) itemView.findViewById(R.id.item_recommend_trend_user_rel);
        user_head_iv = (ImageView) itemView.findViewById(R.id.item_recommend_trend_user_head_iv);
        user_gender_iv = (ImageView) itemView.findViewById(R.id.item_recommend_trend_user_gender_iv);
        user_name_tv = (TextView) itemView.findViewById(R.id.item_recommend_trend_user_name_tv);
        time_tv = (TextView) itemView.findViewById(R.id.item_recommend_trend_time_tv);
        trend_title_tv = (TextView) itemView.findViewById(R.id.item_recommend_trend_title_tv);
        trend_content_tv = (TextView) itemView.findViewById(R.id.item_recommend_trend_content_tv);
        trend_ad_rel = (RelativeLayout) itemView.findViewById(R.id.item_recommend_trend_ad_rel);
        trend_ad_iv = (ImageView) itemView.findViewById(R.id.item_recommend_trend_ad_iv);
        trend_ad_tv = (TextView) itemView.findViewById(R.id.item_recommend_trend_ad_tv);
        trend_discuss_rcv = (RecyclerView) itemView.findViewById(R.id.item_recommend_trend_discuss_rcv);
        trend_readed_tv = (TextView) itemView.findViewById(R.id.item_recommend_trend_readed_tv);
        zannum_tv = (TextView) itemView.findViewById(R.id.item_recommend_trend_zannum_tv);
        text_talk_num = (TextView) itemView.findViewById(R.id.text_talk_num);
        text_zan_num = (TextView) itemView.findViewById(R.id.text_zan_num);
        trend_discuss_rel = (RelativeLayout) itemView.findViewById(R.id.item_recommend_trend_discuss_rel);
        trend_img_rel = (RelativeLayout) itemView.findViewById(R.id.item_recommend_trend_img_rel);
        trend_img_num_tv = (TextView) itemView.findViewById(R.id.item_recommend_trend_img_num_tv);
        trend_discuss_num_tv = (TextView) itemView.findViewById(R.id.item_recommend_trend_discuss_num_tv);
        trend_souce_tv = (TextView) itemView.findViewById(R.id.item_recommend_trend_souce_tv);

        text_trend = (TextView) itemView.findViewById(R.id.text_trend);
        item_recommend_trend_zan_iv = (ImageView) itemView.findViewById(R.id.item_recommend_trend_zan_iv);
        item_recommend_trend_discuss_iv = (ImageView) itemView.findViewById(R.id.item_recommend_trend_discuss_iv);
    }
}

/**
 * 加载更多
 */
class TrendLoadMoreViewHolder extends RecyclerView.ViewHolder {

    TextView load_more_tv;

    public TrendLoadMoreViewHolder(View itemView) {
        super(itemView);
        load_more_tv = (TextView) itemView.findViewById(R.id.item_trend_load_more_tv);
    }
}

//新版广告
class RecommendTrendAdViewHolder2 extends RecyclerView.ViewHolder {

    ImageView itemRecommendTrendUserHeadIv;
    TextView itemRecommendTrendUserNameTv;
    ImageView itemRecommendTrendUserGenderIv;
    TextView itemRecommendTrendTimeTv;
    TextView itemRecommendTrendTitleTv;
    TextView itemRecommendTrendContentTv;
    ImageView ivAdImg;
    TextView itemRecommendTrendReadedTv;

    public RecommendTrendAdViewHolder2(View itemView) {
        super(itemView);
        bindView(itemView);
//        ivAdImg.getLayoutParams().height = (ScreenUtil.getScreenWidth(YDLApplication.getInstance()) -
//                SizeUtil.dp2px(YDLApplication.getInstance(), 30)) * 348 / 640;
//        ivAdImg.requestLayout();
    }
    private void bindView(View bindSource) {
        itemRecommendTrendUserHeadIv = bindSource.findViewById(R.id.item_recommend_trend_user_head_iv);
        itemRecommendTrendUserNameTv = bindSource.findViewById(R.id.item_recommend_trend_user_name_tv);
        itemRecommendTrendUserGenderIv = bindSource.findViewById(R.id.item_recommend_trend_user_gender_iv);
        itemRecommendTrendTimeTv = bindSource.findViewById(R.id.item_recommend_trend_time_tv);
        itemRecommendTrendTitleTv = bindSource.findViewById(R.id.item_recommend_trend_title_tv);
        itemRecommendTrendContentTv = bindSource.findViewById(R.id.item_recommend_trend_content_tv);
        ivAdImg = bindSource.findViewById(R.id.iv_ad_img);
        itemRecommendTrendReadedTv = bindSource.findViewById(R.id.item_recommend_trend_readed_tv);
    }
}
