package com.yidianling.dynamic.adapter;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.miracle.view.imageeditor.utils.FileUtils;
import com.ydl.ydl_image.module.GlideApp;
import com.yidianling.dynamic.R;
import com.ydl.ydlcommon.ui.ParcelableImage;

import java.util.List;

/**
 * Created by xiongyu on 2017/3/14.
 */

public class RecommendTrendImgAdapter extends RecyclerView.Adapter<RecommendTrendImgViewHolder> {
    private static final String TAG = "RecommendTrendImgAdapte";

    protected Context mContext;
    protected List<ParcelableImage> mDatas,mDatas1;
    private  String trend_id;
    protected LayoutInflater mInflater;


    public interface OnItemClickLister {
        void onItemClick(View view, int position);
    }

    private OnItemClickLister mOnItemClickLister;

    public void setOnItemClickLister(OnItemClickLister lister) {
        this.mOnItemClickLister = lister;
    }

    public RecommendTrendImgAdapter(List<ParcelableImage> mDatas, List<ParcelableImage> mDatas1, Context mContext, String trend_id) {
        this.mContext = mContext;
        this.mDatas = mDatas;
        this.mDatas1=mDatas1;
        this.trend_id=trend_id;
        mInflater = LayoutInflater.from(mContext);
    }

    @Override
    public RecommendTrendImgViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view=null;
        view=mInflater.inflate(R.layout.dynamic_item_recommend_trend_img,parent,false);
        RecommendTrendImgViewHolder viewHolder= new RecommendTrendImgViewHolder(view);
        return viewHolder;
    }

    @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
    @Override
    public void onBindViewHolder(RecommendTrendImgViewHolder holder, final int position) {
        ParcelableImage trendImage=mDatas.get(position);
        String img_url=trendImage.getImage_url();
        if(!"no".equals(img_url)){
            Uri uriByPath = FileUtils.INSTANCE.getUriByPath(mContext, img_url);
            GlideApp.with(mContext)
                    .load(uriByPath)
//                .override(width,width)
                    .error(R.drawable.dynamic_default_img)
                    .centerCrop()
//                .bitmapTransform(new CropSquareTransformation(mContext))//裁剪正方形
                    .into(holder.trend_img1);
        }
        setUpItemEvent(holder);
    }

    @Override
    public int getItemCount() {
        if(mDatas.size()>3){
            return 3;
        }else {
            return mDatas.size();
        }
    }



    public void updateDate(List<ParcelableImage> mDatas, List<ParcelableImage> mDatas1) {
        this.mDatas = mDatas;
        this.mDatas1=mDatas1;
        notifyDataSetChanged();
    }

    /**
     * 给item添加监听
     * @param holder
     */
    protected  void setUpItemEvent(final RecommendTrendImgViewHolder holder){
        if(mOnItemClickLister!=null){
            holder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition=holder.getLayoutPosition();
                    mOnItemClickLister.onItemClick(holder.itemView,layoutPosition);

                }
            });
        }
    }
}

class RecommendTrendImgViewHolder extends RecyclerView.ViewHolder{
    ImageView trend_img1;
//    trend_img2,trend_img3;
    public RecommendTrendImgViewHolder(View itemView) {
        super(itemView);
        trend_img1=(ImageView)itemView.findViewById(R.id.item_reconmmend_trend_img_iv1);
//        trend_img2=(ImageView)itemView.findViewById(R.id.item_reconmmend_trend_img_iv2);
    }
}