package com.yidianling.dynamic.adapter;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.ydl.ydl_image.module.GlideApp;
import com.yidianling.common.tools.LogUtil;
import com.yidianling.dynamic.R;
import com.yidianling.dynamic.model.TopicDetailBean;

import java.util.ArrayList;
import java.util.List;

/**
 * 话题详情发帖用户头像
 * Created by xiongyu on 2017/3/14.
 */

public class TopicDetailMemberAdapter extends RecyclerView.Adapter<TopicDetailMemberViewHolder> {
    private static final String TAG = "TopicDetailMemberAdapter";

    protected Context mContext;
    protected List<TopicDetailBean.Member> mDatas;
    protected LayoutInflater mInflater;

    public interface OnItemClickLister {
        void onItemClick(View view, int position);
    }

    public List<TopicDetailBean.Member> getDatas() {
        return mDatas;
    }

    public void addData(int index,TopicDetailBean.Member data) {
        if (data == null) {
            return;
        }
        if (mDatas == null) {
            mDatas = new ArrayList<TopicDetailBean.Member>();
        }
        mDatas.add(index,data);
        notifyItemRangeChanged(index, mDatas.size()-1);
    }

    public void removeData(TopicDetailBean.Member data) {
        if (mDatas==null||mDatas.size()==0){
            return;
        }
        mDatas.remove(data);
        notifyDataSetChanged();
    }

    public void removeData(int index) {
        LogUtil.d("index: " + index + " data size: " + mDatas.size());
        if (mDatas == null) return;
        mDatas.remove(index);
        notifyItemRemoved(index);
        notifyItemRangeChanged(index, mDatas.size()); //解决notifyItemRemoved后数据错乱
    }

    public void addDatas(List<TopicDetailBean.Member> datas) {
        mDatas.addAll(datas);
        notifyItemRangeChanged(mDatas.size() - datas.size(), datas.size());
    }

    public void setDatas(List<TopicDetailBean.Member> datas) {
        if (datas != null) {
            mDatas = datas;
            notifyDataSetChanged();
        }
    }

    private OnItemClickLister mOnItemClickLister;

    public void setOnItemClickLister(OnItemClickLister lister) {
        this.mOnItemClickLister = lister;
    }

    public TopicDetailMemberAdapter(List<TopicDetailBean.Member> mDatas, Context mContext) {
        this.mContext = mContext;
        this.mDatas = mDatas;
        mInflater = LayoutInflater.from(mContext);
    }

    public TopicDetailMemberAdapter(Context mContext) {
        this(new ArrayList<>(), mContext);
    }

    @Override
    public TopicDetailMemberViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = null;
        view = mInflater.inflate(R.layout.dynamic_item_topicdetail_member_head, parent, false);
        TopicDetailMemberViewHolder viewHolder = new TopicDetailMemberViewHolder(view);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(TopicDetailMemberViewHolder holder, final int position) {
        TopicDetailBean.Member topicDetailMemberHead = mDatas.get(position);
        String img_url = topicDetailMemberHead.head;
        GlideApp.with(mContext)
                .load(img_url)
                .error(R.drawable.dynamic_head_place_hold_pic)
                .circleCrop()
                .placeholder(R.drawable.dynamic_head_place_hold_pic)
                .error(R.drawable.dynamic_head_place_hold_pic)
                .into(holder.item_topic_member_head_iv);
        setUpItemEvent(holder);
    }

    @Override
    public int getItemCount() {
        return mDatas.size();
    }


    /**
     * 给item添加监听
     *
     * @param holder
     */
    protected void setUpItemEvent(final TopicDetailMemberViewHolder holder) {
        if (mOnItemClickLister != null) {
            holder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    int layoutPosition = holder.getLayoutPosition();
                    mOnItemClickLister.onItemClick(holder.itemView, layoutPosition);

                }
            });
        }
    }
}

class TopicDetailMemberViewHolder extends RecyclerView.ViewHolder {
    ImageView item_topic_member_head_iv;

    public TopicDetailMemberViewHolder(View itemView) {
        super(itemView);
        item_topic_member_head_iv = (ImageView) itemView.findViewById(R.id.item_topic_member_head_iv);
    }
}