package com.yidianling.dynamic.common.net;


import com.yidianling.dynamic.model.CommentBean;
import com.yidianling.dynamic.model.ExpertBuild;
import com.yidianling.dynamic.model.Focus;
import com.yidianling.dynamic.model.MemberInfoBean;
import com.yidianling.dynamic.model.PublishTrendResult;
import com.yidianling.dynamic.model.Reply;
import com.yidianling.dynamic.model.TestDetail;
import com.yidianling.dynamic.model.TopicDetailBean;
import com.yidianling.dynamic.model.TopicListDataBean;
import com.yidianling.dynamic.model.TrendsDetailInfoBean;
import com.yidianling.dynamic.model.TrendsListBean;
import com.yidianling.dynamic.model.TrendsReplyBean;
import com.yidianling.dynamic.model.ZanResult;
import com.yidianling.dynamic.thank.data.SendThxWithMoney;
import com.yidianling.dynamic.thank.data.ThxData;
import com.yidianling.dynamic.thank.data.ThxListDate;
import com.yidianling.dynamic.thank.data.ZJservice;
import com.ydl.ydlcommon.data.http.BaseAPIResponse;
import com.ydl.ydlcommon.data.http.BaseResponse;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import okhttp3.RequestBody;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PartMap;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;
import retrofit2.http.Url;

import static com.ydl.ydlcommon.base.config.AppConfigKt.YDL_DOMAIN;
import static com.ydl.ydlcommon.base.config.AppConfigKt.YDL_DOMAIN_JAVA;

/**
 * Created by Jim on 2018/2/5 0005.
 */

public interface NetApiStore {

    @FormUrlEncoded
    @POST("ask/zan-list")
    Observable<BaseResponse<ThxListDate>> getZanList(@FieldMap Map<String, String> params);


    // 送感谢 (为了获取相关数据)
    @FormUrlEncoded
    @POST("ask/zan")
    Observable<BaseResponse<ThxData>> getThxHeadData(@FieldMap Map<String, String> params);


    //点赞：动态，回帖，个人主页
    @FormUrlEncoded
    @POST("sq-active/zan")
    Observable<BaseResponse<ZanResult>> zanAction(@FieldMap Map<String, String> params);

    @FormUrlEncoded
    @POST("sq-active/reply-detail")
    Observable<BaseResponse<TrendsReplyBean>> trendsReplyInfo(@FieldMap Map<String, String> params);

    //用户和动态浏览统计
    @FormUrlEncoded
    @POST("sq-active/visit-counter")
    Observable<BaseResponse<Object>> visitCounter(@FieldMap Map<String, String> params);

    //个人资料
    @FormUrlEncoded
    @POST("sq-active/person")
    Observable<BaseResponse<MemberInfoBean>> getMemberInfo(@FieldMap Map<String, String> params);

    //关注
    @FormUrlEncoded
    @POST("sq-active/focus")
    Observable<BaseResponse<Focus>> focus(@FieldMap Map<String, String> params);

    //移出黑名单
    @FormUrlEncoded
    @POST("consult/rm-black")
    Observable<BaseResponse<Object>> rmBlack(@FieldMap Map<String, String> params);

    //加入黑名单
    @FormUrlEncoded
    @POST("consult/set-black")
    Observable<BaseResponse<Object>> setBlackCall(@FieldMap Map<String, String> params);

    //获取举报理由
    @FormUrlEncoded
    @POST("ask/report-reason")
    Observable<BaseResponse> getReportReason(@FieldMap Map<String, String> params);

    //举报心事或者心事回复(动态)
    @FormUrlEncoded
    @POST("ask/report")
    Observable<BaseResponse<Object>> reportWorry(@FieldMap Map<String, String> params);

    //发布动态
    @POST("sq-active/publish")
    @Multipart
    Observable<BaseResponse<PublishTrendResult>> publishTrend(@PartMap Map<String, RequestBody> params);

    //话题列表
    @FormUrlEncoded
    @POST("sq-active/topic-list")
    Observable<BaseResponse<TopicListDataBean>> fetchTopicList(@FieldMap Map<String, String> params);

    //话题详情
    @GET()
    @Headers({YDL_DOMAIN + YDL_DOMAIN_JAVA,"Content-Type:application/json"})
    Observable<BaseAPIResponse<TopicDetailBean>> getTopicDetail(@Url String url);

    //预约下单页面数据
    @POST("site/focus-click-counter")
    @FormUrlEncoded
    Observable<BaseResponse<Object>> adClickCount(@FieldMap Map<String, String> maps);

    //动态列表(php) 老的
    @FormUrlEncoded
    @POST("sq-active/active-list")
    Observable<TrendsListBean> fetchPhpTrendList(@FieldMap Map<String, String> params);

    //动态列表(java)
    @GET("ask/list-old")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    Observable<BaseAPIResponse<TrendsListBean>> fetchTrendList(@QueryMap Map<String, String> params);

    //个人动态
    @FormUrlEncoded
    @POST("sq-active/person-active")
    Observable<BaseResponse<List<TrendsListBean.Trend>>> getUserTrend(@FieldMap Map<String, String> params);

    //获取测试详情
    @FormUrlEncoded
    @POST("ceshi/detail")
    Observable<BaseResponse<TestDetail>> fetchTestDetail(@FieldMap Map<String, String> params);

    //获取社区帖子评论列表
    @FormUrlEncoded
    @POST("sq-active/active-comments")
    Observable<BaseResponse<List<CommentBean>>> fetchTrendsComments(@FieldMap Map<String, String> params);

    //帖子或评论删除
    @FormUrlEncoded
    @POST("sq-active/remove")
    Observable<BaseResponse<Object>> removeTrendsReply(@FieldMap Map<String, String> params);

    //私聊 获取聊天者的订单关系数据
    @FormUrlEncoded
    @POST("consult/get-expert")
    Observable<BaseResponse<ExpertBuild>> getExpert(@FieldMap Map<String, String> params);

    //获取用户的状态（用户、专家、助理）
    @GET("user/userType")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    Observable<BaseAPIResponse<String>> getUserType(@Query("targetUid") String uid);

    //私聊 获取聊天者的订单关系数据   -----进入聊天前调用的接口，采用新的java接口，直接php  getExpert 接口废弃
    @GET("doctor/personalChat")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    Observable<BaseResponse<ExpertBuild>> getPersonalChat(@Query("doctorUid") String doctorUid);

    //回复盖楼
    @FormUrlEncoded
    @POST("sq-active/reply")
    Observable<BaseResponse<Reply>> commitOrReply(@FieldMap Map<String, String> params);

    //动态详情
    @GET("ask/detail-old")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    Observable<BaseAPIResponse<TrendsDetailInfoBean>> fetchTrendsDetailInfo(@QueryMap Map<String, String> params);

    //感谢表单提交
    @FormUrlEncoded
    @POST("ask/zan-act")
    Observable<BaseResponse<SendThxWithMoney>> submitZan(@FieldMap Map<String, String> params);

    //获取专家相关信息
    @FormUrlEncoded
    @POST("doctor/get-service")
    Observable<BaseResponse<ZJservice>> getService(@FieldMap Map<String, String> params);
}