package com.yidianling.dynamic.common.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.View;

import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;
import com.yidianling.dynamic.common.browsePictures.BrowsePicturesActivity2;

import java.util.ArrayList;
import java.util.List;

;

/**
 * ================================================
 * 作    者：廖子尧
 * 版    本：1.0
 * 创建日期：2016/3/21
 * 描    述：
 * 修订历史：
 * ================================================
 */
public class NineGridViewClickAdapter extends NineGridViewAdapter {

    private int statusHeight;

    public NineGridViewClickAdapter(Context context, List<ImageInfo> imageInfo) {
        super(context, imageInfo);
        statusHeight = getStatusHeight(context);
    }

    @Override
    protected void onImageItemClick(Context context, NineGridView nineGridView, int index, List<ImageInfo> imageInfo) {
        for (int i = 0; i < imageInfo.size(); i++) {
            ImageInfo info = imageInfo.get(i);
            View imageView;
            if (i < nineGridView.getMaxSize()) {
                imageView = nineGridView.getChildAt(i);
            } else {
                //如果图片的数量大于显示的数量，则超过部分的返回动画统一退回到最后一个图片的位置
                imageView = nineGridView.getChildAt(nineGridView.getMaxSize() - 1);
            }
            info.imageViewWidth = imageView.getWidth();
            info.imageViewHeight = imageView.getHeight();
            int[] points = new int[2];
            imageView.getLocationInWindow(points);
            info.imageViewX = points[0];
            info.imageViewY = points[1] - statusHeight;
        }

        if (!TextUtils.isEmpty(imageInfo.get(index).imageLinkUrl)) {
            NewH5Activity.start(context, new H5Params(imageInfo.get(index).imageLinkUrl, null, imageInfo.get(index).mShareData));
            return;
        }
        Intent intent = new Intent();
        intent.setClass(context, BrowsePicturesActivity2.class);
        intent.putExtra("position", index);
        intent.putExtra("browse_type", "browse");
        ArrayList<String> urls=new ArrayList<>();
        for (int i=0;i<imageInfo.size();i++){
            urls.add(imageInfo.get(i).bigImageUrl);
        }
        intent.putStringArrayListExtra("allTrendImages",urls );
//                bd.putParcelableArrayList("allTrendImages", (ArrayList<? extends Parcelable>) trendsDatas.get(mposition).getTrendBigImages());
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);

        ((Activity) context).overridePendingTransition(0, 0);
    }

    /**
     * 获得状态栏的高度
     */
    public int getStatusHeight(Context context) {
        int statusHeight = -1;
        try {
            Class<?> clazz = Class.forName("com.android.internal.R$dimen");
            Object object = clazz.newInstance();
            int height = Integer.parseInt(clazz.getField("status_bar_height").get(object).toString());
            statusHeight = context.getResources().getDimensionPixelSize(height);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return statusHeight;
    }
}
