package com.yidianling.dynamic.dialog

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.view.WindowManager
import com.yidianling.dynamic.R
import com.yidianling.dynamic.dialog.listener.CancelFocusDialogListener
import kotlinx.android.synthetic.main.dynamic_cancel_focus_dialog_layout.*

/**
 * Created by xj on 2019/9/25.
 */
class CancelFocusDialog(val mContext: Context, val listener: CancelFocusDialogListener): Dialog(mContext, R.style.dialog_default_style) {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContentView(R.layout.dynamic_cancel_focus_dialog_layout)

        val params = window.attributes
        params.width = WindowManager.LayoutParams.MATCH_PARENT
        params.height = WindowManager.LayoutParams.MATCH_PARENT
        window.attributes = params

        cancel_focus_dialog_cancel.setOnClickListener { hide() }

        cancel_focus_dialog_sure.setOnClickListener {
            listener?.onSure()
            hide()
        }


    }

}