package com.yidianling.dynamic.dialog

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.view.Gravity
import android.view.WindowManager
import com.yidianling.dynamic.R
import com.yidianling.dynamic.dialog.listener.DynamicQuestionSaveListener
import kotlinx.android.synthetic.main.dynamic_savedraft_dialog_layout.*

/**
 * Created by xj on 2019/9/25.
 */
class DynamicSaveDraftDialog(val mContext: Context, val listener: DynamicQuestionSaveListener): Dialog(mContext, R.style.dialog_default_style) {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.dynamic_savedraft_dialog_layout)

        val params = window.attributes
        params.width = WindowManager.LayoutParams.WRAP_CONTENT
        params.height = WindowManager.LayoutParams.WRAP_CONTENT
        params.gravity=Gravity.CENTER

        window.attributes = params
        window.decorView.setPadding(50,0,50,0)
        setCanceledOnTouchOutside(false)
        cancel_btn.setOnClickListener {
            listener.notSave()
            hide()
        }

        confirm_btn.setOnClickListener {
            listener.save()
            hide()
        }

    }

}