package com.yidianling.dynamic.members;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.yidianling.dynamic.DynamicFragment;
import com.yidianling.dynamic.R;


/**
 * 会员主页个人资料
 * Created by xiongyu on 2017/3/27.
 */

public class MemberFragment extends DynamicFragment {

    private View view;
    private Context context;
    private TextView member_age_tv,member_emotional_state_tv,member_job_tv,member_address_tv,member_introduction_tv,member_ip_tv;

    String age,emotional_state,job,address,introduction,ipProvince;

    public static MemberFragment newInstance(String age, String emotional_state, String job, String address, String introduction, String ipProvince){
        MemberFragment memberFragment=new MemberFragment();
        Bundle args = new Bundle();
        args.putString("age", age);
        args.putString("emotional_state", emotional_state);
        args.putString("job", job);
        args.putString("address", address);
        args.putString("introduction", introduction);
        args.putString("ipProvince", ipProvince);
        memberFragment.setArguments(args);
        return memberFragment;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        view = this.getActivity().getLayoutInflater().inflate(R.layout.dynamic_fragment_member, null);
        context = getActivity().getApplicationContext();
        member_age_tv=(TextView)view.findViewById(R.id.member_age_tv);
        member_emotional_state_tv=(TextView)view.findViewById(R.id.member_emotional_state_tv);
        member_job_tv=(TextView)view.findViewById(R.id.member_job_tv);
        member_address_tv=(TextView)view.findViewById(R.id.member_address_tv);
        member_introduction_tv=(TextView)view.findViewById(R.id.member_introduction_tv);
        member_ip_tv = view.findViewById(R.id.member_ip_tv);

        age=getArguments().getString("age");
        emotional_state=getArguments().getString("emotional_state");
        job=getArguments().getString("job");
        address=getArguments().getString("address");
        introduction=getArguments().getString("introduction");
        ipProvince=getArguments().getString("ipProvince");

        member_age_tv.setText(age);
        member_emotional_state_tv.setText(emotional_state);
        member_job_tv.setText(job);
        member_address_tv.setText(address);
        member_introduction_tv.setText(introduction);
        member_ip_tv.setText(ipProvince);
        return view;
    }
}
