package com.yidianling.dynamic.model;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * 评论实体类
 * Created by xiongyu on 2017/3/14.
 */

public class RecommendedDiscuss implements Parcelable{
    private String dicuss_id;//评论id
    private String user_id;//发布评论的用户id
    private String user_name;//发布评论的用户名
    private String trend_id;//对应的动态id
    private String type;//评论类型
    private String reply_user_id;//回复对象的用户id
    private String reply_user_name;//回复对象的用户名
    private String content;//评论内容
    private String dicuss_time;//评论时间

    public RecommendedDiscuss() {
    }

    public RecommendedDiscuss(String dicuss_id, String user_id, String user_name, String trend_id, String type, String reply_user_id, String reply_user_name, String content, String dicuss_time) {
        this.dicuss_id = dicuss_id;
        this.user_id = user_id;
        this.user_name = user_name;
        this.trend_id = trend_id;
        this.type = type;
        this.reply_user_id = reply_user_id;
        this.reply_user_name = reply_user_name;
        this.content = content;
        this.dicuss_time = dicuss_time;
    }

    protected RecommendedDiscuss(Parcel in) {
        dicuss_id = in.readString();
        user_id = in.readString();
        user_name = in.readString();
        trend_id = in.readString();
        type = in.readString();
        reply_user_id = in.readString();
        reply_user_name = in.readString();
        content = in.readString();
        dicuss_time = in.readString();
    }

    public static final Creator<RecommendedDiscuss> CREATOR = new Creator<RecommendedDiscuss>() {
        @Override
        public RecommendedDiscuss createFromParcel(Parcel in) {

            return new RecommendedDiscuss(in);
        }

        @Override
        public RecommendedDiscuss[] newArray(int size) {
            return new RecommendedDiscuss[size];
        }
    };

    public String getDicuss_id() {
        return dicuss_id;
    }

    public void setDicuss_id(String dicuss_id) {
        this.dicuss_id = dicuss_id;
    }

    public String getUser_id() {
        return user_id;
    }

    public void setUser_id(String user_id) {
        this.user_id = user_id;
    }

    public String getUser_name() {
        return user_name;
    }

    public void setUser_name(String user_name) {
        this.user_name = user_name;
    }

    public String getTrend_id() {
        return trend_id;
    }

    public void setTrend_id(String trend_id) {
        this.trend_id = trend_id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getReply_user_id() {
        return reply_user_id;
    }

    public void setReply_user_id(String reply_user_id) {
        this.reply_user_id = reply_user_id;
    }

    public String getReply_user_name() {
        return reply_user_name;
    }

    public void setReply_user_name(String reply_user_name) {
        this.reply_user_name = reply_user_name;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getDicuss_time() {
        return dicuss_time;
    }

    public void setDicuss_time(String dicuss_time) {
        this.dicuss_time = dicuss_time;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(dicuss_id);
        dest.writeString(user_id);
        dest.writeString(user_name);
        dest.writeString(trend_id);
        dest.writeString(type);
        dest.writeString(reply_user_id);
        dest.writeString(reply_user_name);
        dest.writeString(content);
        dest.writeString(dicuss_time);
    }
}
