package com.yidianling.dynamic.model

import android.os.Parcel
import android.os.Parcelable
import com.google.gson.annotations.SerializedName
import com.ydl.ydlcommon.bean.ShareData
/**
 * Created by Jim on 2018/2/11 0011.
 */
data class TestDetail(

        @field:SerializedName("test_item")
        val testItem: TestItem? = null,

        @field:SerializedName("test_question")
        val testQuestionList: List<TestQuestionItem>? = null,

        @field:SerializedName("share")
        val share: ShareData? = null
) : Parcelable {
    constructor(source: Parcel) : this(
            source.readParcelable<TestItem>(TestItem::class.java.classLoader),
            source.createTypedArrayList(TestQuestionItem.CREATOR),
            source.readSerializable() as ShareData?
    )

    override fun describeContents() = 0

    override fun writeToParcel(dest: Parcel, flags: Int) = with(dest) {
        writeParcelable(testItem, 0)
        writeTypedList(testQuestionList)
        writeSerializable(share)
    }

    companion object {
        @JvmField
        val CREATOR: Parcelable.Creator<TestDetail> = object : Parcelable.Creator<TestDetail> {
            override fun createFromParcel(source: Parcel): TestDetail = TestDetail(source)
            override fun newArray(size: Int): Array<TestDetail?> = arrayOfNulls(size)
        }
    }
}

data class TestItem(

        @field:SerializedName("cover")
        val cover: String? = null,

        @field:SerializedName("comment_num")
        val commentNum: String? = null,

        @field:SerializedName("test_pattern")
        val testPattern: String? = null,

        @field:SerializedName("test_num")
        val testNum: Int = 0,

        @field:SerializedName("create_time")
        val createTime: String? = null,

        @field:SerializedName("name")
        val name: String? = null,

        @field:SerializedName("tips_title")
        val tipsTitle: String? = null,

        @field:SerializedName("is_job_number")
        val isJobNumber: String? = null,

        @field:SerializedName("id")
        val id: String? = null,

        @field:SerializedName("is_jump")
        val isJump: String? = null,

        @field:SerializedName("is_need_user_info")
        val isNeedUserInfo: String? = null,

        @field:SerializedName("desc")
        val desc: String? = null
) : Parcelable {
    constructor(source: Parcel) : this(
            source.readString(),
            source.readString(),
            source.readString(),
            source.readInt(),
            source.readString(),
            source.readString(),
            source.readString(),
            source.readString(),
            source.readString(),
            source.readString(),
            source.readString(),
            source.readString()
    )

    override fun describeContents() = 0

    override fun writeToParcel(dest: Parcel, flags: Int) = with(dest) {
        writeString(cover)
        writeString(commentNum)
        writeString(testPattern)
        writeInt(testNum)
        writeString(createTime)
        writeString(name)
        writeString(tipsTitle)
        writeString(isJobNumber)
        writeString(id)
        writeString(isJump)
        writeString(isNeedUserInfo)
        writeString(desc)
    }

    companion object {
        @JvmField
        val CREATOR: Parcelable.Creator<TestItem> = object : Parcelable.Creator<TestItem> {
            override fun createFromParcel(source: Parcel): TestItem = TestItem(source)
            override fun newArray(size: Int): Array<TestItem?> = arrayOfNulls(size)
        }
    }
}

data class TestQuestionItem(

        @field:SerializedName("test_answer")
        val testAnswerList: List<TestAnswerItem?>? = null,

        @field:SerializedName("image")
        val image: String? = null,

        @field:SerializedName("question_no")
        val questionNo: String? = null,

        @field:SerializedName("id")
        val id: String? = null,

        @field:SerializedName("content")
        val content: String? = null
) : Parcelable {
    constructor(source: Parcel) : this(
            source.createTypedArrayList(TestAnswerItem.CREATOR),
            source.readString(),
            source.readString(),
            source.readString(),
            source.readString()
    )

    override fun describeContents() = 0

    override fun writeToParcel(dest: Parcel, flags: Int) = with(dest) {
        writeTypedList(testAnswerList)
        writeString(image)
        writeString(questionNo)
        writeString(id)
        writeString(content)
    }

    companion object {
        @JvmField
        val CREATOR: Parcelable.Creator<TestQuestionItem> = object : Parcelable.Creator<TestQuestionItem> {
            override fun createFromParcel(source: Parcel): TestQuestionItem = TestQuestionItem(source)
            override fun newArray(size: Int): Array<TestQuestionItem?> = arrayOfNulls(size)
        }
    }
}


data class TestAnswerItem(

        @field:SerializedName("answer_no")
        val answerNo: String? = null,

        @field:SerializedName("jump_ans_id")
        val jumpAnsId: String? = null,

        @field:SerializedName("id")
        val id: String? = null,

        @field:SerializedName("question_id")
        val questionId: String? = null,

        @field:SerializedName("content")
        val content: String? = null
) : Parcelable {
    constructor(source: Parcel) : this(
            source.readString(),
            source.readString(),
            source.readString(),
            source.readString(),
            source.readString()
    )

    override fun describeContents() = 0

    override fun writeToParcel(dest: Parcel, flags: Int) = with(dest) {
        writeString(answerNo)
        writeString(jumpAnsId)
        writeString(id)
        writeString(questionId)
        writeString(content)
    }

    companion object {
        @JvmField
        val CREATOR: Parcelable.Creator<TestAnswerItem> = object : Parcelable.Creator<TestAnswerItem> {
            override fun createFromParcel(source: Parcel): TestAnswerItem = TestAnswerItem(source)
            override fun newArray(size: Int): Array<TestAnswerItem?> = arrayOfNulls(size)
        }
    }
}