package com.yidianling.dynamic.modular.service

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.os.Bundle
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentActivity
import com.alibaba.android.arouter.facade.annotation.Route
import com.yidianling.dynamic.activity.MyTrendsActivity
import com.yidianling.dynamic.activity.TrendsReplyInfoActivity
import com.yidianling.dynamic.api.IDynamicService
import com.yidianling.dynamic.bean.DynamicConstants
import com.yidianling.dynamic.common.browsePictures.BrowsePicturesActivity
import com.yidianling.dynamic.common.tool.ImageCompress
import com.yidianling.dynamic.members.MembersActivity
import com.yidianling.dynamic.publishTrend.PublishTrendActivity
import com.yidianling.dynamic.topic.topicDetail.TopicDetailActivity
import com.yidianling.dynamic.trendsDetail.TrendsDetailActivity
import com.yidianling.dynamic.trendsHome.TrendsHomeFragment
import java.io.File

/**
 * Created by haorui on 2019-12-17 .
 * Des:
 */
@Route(path = "/dynamic/DynamicService")
class DynamicServiceImp : IDynamicService {

    override fun init(context: Context?) {

    }

    override fun membersIntent(activity: Activity, userId: String): Intent {
        return MembersActivity.newIntent(activity, userId)
    }

    override fun replyInfoIntent(activity: Activity, replyId: String, aid: String): Intent {
        return TrendsReplyInfoActivity.newIntent(activity, replyId, aid)
    }

    override fun trendsDetailIntent(activity: Activity, trendId: Int): Intent {
        return TrendsDetailActivity.newIntent(activity, trendId)
    }

    override fun startTrendsDetail(activity: Activity, trendId: Int, isSplash: Boolean, isComment: Boolean, isScrollToZan: Boolean, isScrollToComment: Boolean, lastId: Int) {
        TrendsDetailActivity.start(activity, trendId, isSplash, isComment, isScrollToZan, isScrollToComment, lastId)
    }


    override fun trendsDetailIntent(activity: Activity, trendId: Int, isScrollToZan: Boolean): Intent {
        return TrendsDetailActivity.newIntent(activity, trendId, isScrollToZan)
    }

    override fun trendsDetailIntent(activity: Activity, trendId: Int, isScrollToZan: Boolean, lastId: Int): Intent {
        return TrendsDetailActivity.newIntent(activity, trendId, isScrollToZan, lastId)
    }

    override fun publishTrendIntent(activity: Activity, url: String, cover: String, title: String): Intent {
        return PublishTrendActivity.newIntent(activity, url, cover, title)
    }

    override fun publishTrendIntent(activity: Activity): Intent {
        val intent = Intent()
        intent.setClass(activity, PublishTrendActivity::class.java)
        val bundle = Bundle()
        intent.putExtra("bundle", bundle)
        return intent
    }

    override fun publishFmToTrend(activity: Activity, url: String, cover: String, title: String): Intent {
        return PublishTrendActivity.newIntentForFm(activity, url, cover, title, 1)
    }

    override fun publishArticleToTrend(activity: Activity, url: String, cover: String, title: String): Intent {
        return PublishTrendActivity.newIntentForArticle(activity, url, cover, title)
    }

    override fun topicDetailIntent(context: Activity, isSplash: Boolean, topicId: String): Intent {
        return TopicDetailActivity.newIntent(context, isSplash, topicId)
    }

    override fun getTrendsHomeFragment(tabIndex: String): Fragment {
        return TrendsHomeFragment().setTab(tabIndex)
    }

    override fun getPublicPicBrowType(): Int {
        return DynamicConstants.PUBLISH_PIC_BROW
    }

    override fun imageCompressScal(activity: FragmentActivity, path: String, size: Int): File {
        return ImageCompress.scal(activity, path, size)
    }

    /**
     * 外部调用获取intent后注意，需使用以下方式
     *  intent.putExtra("browse_type", "preview")
        intent.putExtra("position", position)
        val bd = Bundle()
        bd.putParcelableArrayList("allTrendImages", imags as ArrayList<out Parcelable>?)
        intent.putExtra("allTrendImages_bd", bd)
        startActivityForResult(intent, ModularServiceManager.provide(IDynamicService::class.java).getPublicPicBrowType())
     */
    override fun getBrosePictureActivityIntent(activity: Activity): Intent {
        val intent = Intent()
        intent.setClass(activity, BrowsePicturesActivity::class.java)
        return intent
    }

    override fun getMyTrendsActivityIntent(activity: Activity): Intent {
        val intent = Intent()
        intent.setClass(activity, MyTrendsActivity::class.java)
        return intent
    }
}