package com.yidianling.dynamic.router

import android.app.Activity
import android.content.Context
import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import androidx.fragment.app.DialogFragment
import com.ydl.confide.api.IConfideService
import com.ydl.course.api.ICourseService
import com.ydl.ydlcommon.base.config.HttpConfig
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.yidianling.consultant.api.IConsultantService
import com.yidianling.dynamic.api.IDynamicService
import com.yidianling.fm.api.service.IFMService
import com.yidianling.im.api.service.IImService
import com.yidianling.tests.api.service.ITestsApiService
import com.yidianling.user.api.bean.UserResponseBean
import com.yidianling.user.api.service.IAppService
import com.yidianling.user.api.service.IUserService

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/04/25
 */
object DynamicIn {

    fun getImService(): IImService {
        return ModularServiceManager.provide(IImService::class.java)
    }

    fun getAppService(): IAppService {
        return ModularServiceManager.provide(IAppService::class.java)
    }

    fun getUserService(): IUserService {
        return ModularServiceManager.provide(IUserService::class.java)
    }

    fun getDynamicService(): IDynamicService {
        return ModularServiceManager.provide(IDynamicService::class.java)
    }

    fun getCourseService(): ICourseService {
        return ModularServiceManager.provide(ICourseService::class.java)
    }

    fun getTestsService(): ITestsApiService {
        return ModularServiceManager.provide(ITestsApiService::class.java)
    }

    fun getFMService(): IFMService {
        return ModularServiceManager.provide(IFMService::class.java)
    }

    fun getConsultService(): IConsultantService {
        return ModularServiceManager.provide(IConsultantService::class.java)
    }

    fun getConfideService(): IConfideService {
        return ModularServiceManager.provide(IConfideService::class.java)
    }

    /**
     * 获取专家主页url
     */
    fun getExpertHost(): String {
        return HttpConfig.MH5_URL + "jy/experts/"
    }

    fun getShareExpertHost(): String {
        return HttpConfig.MH5_URL + "experts/"
    }

    fun isLogin(): Boolean {
        return getUserService().isLogin() ?: false
    }

    fun getUserInfo(): UserResponseBean.UserInfo? = getUserService().getUserInfo()

    fun loginWayIntent(activity: Activity): Intent {
        return getUserService().loginWayIntent(activity)
    }

    fun personalInfoIntent(activity: Activity) {
        getAppService().personalInfoIntent(activity)
    }

    fun inputPhoneIntent(activity: Activity, smsAction: String): Intent {
        return getUserService().inputPhoneIntent(activity, smsAction)
    }

    fun mainIntent(activity: Activity) {
        getAppService().mainIntent(activity)
    }

    fun mainIntent(activity: Activity, tab: Int) {
        getAppService().mainIntent(activity, tab, false)
    }

    fun expertSearchIntent(
        activity: Activity,
        category: Int,
        showType: Int,
        isInitShowHot: Boolean
    ): Intent? {
        return getConsultService().expertSearchIntent(activity, category.toString(), showType, isInitShowHot)
    }

    fun testResultH5(testResultId: Int) {
        getTestsService().testH5Result(testResultId.toString())
    }

    fun testDetailH5(testId: Int) {
        getTestsService().testDetailH5(testId.toString());
    }

    fun phoneCallIntent(activity: Activity): Intent {
        return getConfideService().phoneCallIntent(activity)
    }

    fun fmDetailIntent(activity: Activity, fmId: Int): Intent {
        return getFMService().fmDetailIntent(activity, fmId)
    }

    fun getFmId(): Int {
        return getFMService().getFmId() ?: 0
    }

    fun rechargeIntent(activity: Activity) {
        getAppService().rechargeIntent(activity)
    }

    fun phoneCallFragment(head: String, callId: String): DialogFragment {
        return getConfideService().phoneCallFragment(head, callId)
    }


    fun startChat(activity: AppCompatActivity, toUid: String) {
        getImService().startP2PSession(activity, toUid)
    }

    fun isFmPlaying(): Boolean {
        return getFMService().isPlaying()
    }

    fun isCoursePlaying(): Boolean {
        return getCourseService().isPlaying()
    }

    fun playCourse() {
        if (!isCoursePlaying()) {
            getCourseService().play()
        }
    }

    fun pauseCourse() {
        if (isCoursePlaying()) {
            getCourseService().pause()
        }
    }

    fun rePlayFM() {
        getFMService().replay()
    }

    fun pauseFm() {
        getFMService().pause()
    }

    fun showSelector(activity: Activity, requestCode: Int) {
        getImService().showSelector(activity, requestCode)
    }

    /**
     * 课程播放页
     */
    fun startCoursePlayPage(activity: Activity) {
        getCourseService().startCoursePlayPage(activity, 1)
    }

    /**
     * 调用优先使用一键登录，并返回调用时的登录状态，
     * @param isOpenDialog true:一键登录使用弹窗展示 false:一键登录使用全屏模式
     * @return true：已登录，不触发登录跳转，false：未登录，优先一键登录
     * */
    fun loginByOneKeyLogin(context: Context, isOpenDialog: Boolean): Boolean {
        return getUserService().loginByOneKeyLogin(context, isOpenDialog)
    }
}