package com.yidianling.dynamic.thank.view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.yidianling.dynamic.R;
import com.yidianling.dynamic.thank.ThxStarMoney;

import java.util.List;

/**
 * 感谢的选择器
 * Created by softrice on 15/12/3.
 */
public class ThxSelectView extends LinearLayout {

    private LinearLayout ll_left;
    private TextView tv_left_up;
    private TextView tv_left_down;

    private LinearLayout ll_center;
    private TextView tv_center_up;
    private TextView tv_center_down;

    private LinearLayout ll_right;
    private TextView tv_right_up;
    private TextView tv_right_down;

    int selectId = -1;

    int selectColor = 0xFFEB5835;
    int disSelectColor = Color.WHITE;

    List<ThxStarMoney> star_money;

    public ThxSelectView(Context context) {
        super(context);
        inflate(context, R.layout.dynamic_ui_thx_select, this);
        bindView(this);
    }


    public ThxSelectView(Context context, AttributeSet attrs) {
        super(context, attrs);
        inflate(context, R.layout.dynamic_ui_thx_select, this);
        bindView(this);
    }

    public void select(int position) {
        if (position >= 0 && position < 3) {
            Drawable drawable = getResources().getDrawable(R.drawable.dynamic_love_white);
            cleanSelect();
            selectId = position;
            switch (position) {
                case 0:
                    ll_left.setBackgroundResource(R.drawable.dynamic_shape_red_bg);
                    tv_left_down.setTextColor(disSelectColor);
                    tv_left_up.setTextColor(disSelectColor);
                    tv_left_up.setCompoundDrawablesWithIntrinsicBounds(drawable, null, null, null);
                    break;

                case 1:
                    ll_center.setBackgroundResource(R.drawable.dynamic_shape_red_bg);
                    tv_center_down.setTextColor(disSelectColor);
                    tv_center_up.setTextColor(disSelectColor);
                    tv_center_up.setCompoundDrawablesWithIntrinsicBounds(drawable, null, null, null);
                    break;

                case 2:
                    ll_right.setBackgroundResource(R.drawable.dynamic_shape_red_bg);
                    tv_right_down.setTextColor(disSelectColor);
                    tv_right_up.setTextColor(disSelectColor);
                    tv_right_up.setCompoundDrawablesWithIntrinsicBounds(drawable, null, null, null);
                    break;
            }
        }
    }

    public int getSelectId() {
        return selectId;
    }

    public int getStarNum() {
        if (selectId != -1 && star_money != null && star_money.size() >= 3)
            return star_money.get(selectId).star_num;
        return 0;
    }

    public float getMoney() {
        if (selectId != -1 && star_money != null && star_money.size() >= 3)
            return star_money.get(selectId).money;
        return 0;
    }

    void cleanSelect() {
        Drawable drawable = getResources().getDrawable(R.drawable.dynamic_love_red);
        ll_left.setBackgroundResource(R.drawable.dynamic_shape_red_round);
        tv_left_down.setTextColor(selectColor);
        tv_left_up.setTextColor(selectColor);
        tv_left_up.setCompoundDrawablesWithIntrinsicBounds(drawable, null, null, null);

        ll_center.setBackgroundResource(R.drawable.dynamic_shape_red_round);
        tv_center_down.setTextColor(selectColor);
        tv_center_up.setTextColor(selectColor);
        tv_center_up.setCompoundDrawablesWithIntrinsicBounds(drawable, null, null, null);

        ll_right.setBackgroundResource(R.drawable.dynamic_shape_red_round);
        tv_right_down.setTextColor(selectColor);
        tv_right_up.setTextColor(selectColor);
        tv_right_up.setCompoundDrawablesWithIntrinsicBounds(drawable, null, null, null);

    }

    private void click(@NonNull View view) {
        if (view.getId() == R.id.ll_left) {
            select(0);
        } else if (view.getId() == R.id.ll_center) {
            select(1);
        } else if (view.getId() == R.id.ll_right) {
            select(2);
        }


    }


    public void setData(List<ThxStarMoney> star_money) {
        this.star_money = star_money;
        if (star_money != null && star_money.size() >= 3) {
            tv_left_down.setText("价值" + star_money.get(0).money + "元");
            tv_left_up.setText("×" + star_money.get(0).star_num);

            tv_center_down.setText("价值" + star_money.get(1).money + "元");
            tv_center_up.setText("×" + star_money.get(1).star_num);

            tv_right_down.setText("价值" + star_money.get(2).money + "元");
            tv_right_up.setText("×" + star_money.get(2).star_num);
        }
    }

    private void bindView(View bindSource) {
        ll_left = bindSource.findViewById(R.id.ll_left);
        tv_left_up = bindSource.findViewById(R.id.tv_left_up);
        tv_left_down = bindSource.findViewById(R.id.tv_left_down);
        ll_center = bindSource.findViewById(R.id.ll_center);
        tv_center_up = bindSource.findViewById(R.id.tv_center_up);
        tv_center_down = bindSource.findViewById(R.id.tv_center_down);
        ll_right = bindSource.findViewById(R.id.ll_right);
        tv_right_up = bindSource.findViewById(R.id.tv_right_up);
        tv_right_down = bindSource.findViewById(R.id.tv_right_down);
        ll_left.setOnClickListener(v -> {
            click(v);
        });
        ll_center.setOnClickListener(v -> {
            click(v);
        });
        ll_right.setOnClickListener(v -> {
            click(v);
        });
    }
}
