package com.yidianling.dynamic.thank.view;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.ydl.ydl_image.module.GlideApp;
import com.ydl.ydl_image.transform.GlideCircleTransform;
import com.yidianling.dynamic.R;
import com.yidianling.dynamic.thank.data.ThxZan;

/**
 * 感谢回复
 * Created by softrice on 15/12/3.
 */
public class ZanReplyListItemView extends LinearLayout {

    private ImageView sdv_head;
    private TextView tv_zan_num;
    private TextView tv_name;
    private TextView tv_time;
    private TextView tv_content;


    public ZanReplyListItemView(Context context) {
        super(context);
        inflate(context,R.layout.dynamic_ui_zan_reply_list,this);
        bindView(this);

    }


    public void setData(ThxZan thxZan) {
        GlideApp.with(getContext())
                .load(thxZan.head)
                .transform(new GlideCircleTransform(getContext()))
                .placeholder(R.drawable.dynamic_head_place_hold_pic)
                .error(R.drawable.dynamic_head_place_hold_pic)
                .into(sdv_head);
        if (thxZan.num.endsWith("0"))
            tv_zan_num.setText("");
        else
            tv_zan_num.setText(thxZan.num);
        tv_name.setText(thxZan.name);
        tv_time.setText(thxZan.time);
        tv_content.setText(thxZan.content);
    }


    private void bindView(View bindSource) {
        sdv_head = bindSource.findViewById(R.id.sdv_head);
        tv_zan_num = bindSource.findViewById(R.id.tv_zan_num);
        tv_name = bindSource.findViewById(R.id.tv_name);
        tv_time = bindSource.findViewById(R.id.tv_time);
        tv_content = bindSource.findViewById(R.id.tv_content);
    }
}
