package com.yidianling.dynamic.topic;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import com.ydl.ydlcommon.data.http.RxUtils;
import com.ydl.ydlcommon.utils.BuryPointUtils;
import com.ydl.ydlcommon.view.FullyLinearLayoutManager;
import com.ydl.ydlcommon.view.widgets.RecyclerViewForScrollView;
import com.yidianling.common.tools.LogUtil;
import com.yidianling.common.tools.ToastUtil;
import com.yidianling.dynamic.DynamicFragment;
import com.yidianling.dynamic.R;
import com.yidianling.dynamic.adapter.AllTopicAdapter;
import com.yidianling.dynamic.common.net.DynamicApiUtils;
import com.yidianling.dynamic.model.Command;
import com.yidianling.dynamic.model.RecommendTopic;
import com.yidianling.dynamic.router.DynamicIn;
import com.yidianling.dynamic.topic.topicDetail.TopicDetailActivity;

import java.util.ArrayList;
import java.util.List;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;

/**
 * 全部话题
 * Created by xiongyu on 2017/3/16.
 */

public class AllTopicFragment extends DynamicFragment {
    Context context;
    View view;
    private RecyclerViewForScrollView all_topic_focus_rcv, all_topic_recommend_rcv;
    private List<RecommendTopic> mDatasf, mDatasr;
    private AllTopicAdapter adapterf, adapterr;
    private RelativeLayout all_topic_focus_rel, all_topic_recommend_rel;


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        view = inflater.inflate(R.layout.dynamic_fragment_all_topic, container, false);
        context = getActivity().getApplicationContext();
        initView();
        return view;
    }


    private void initView() {
        all_topic_focus_rcv = (RecyclerViewForScrollView) view.findViewById(R.id.all_topic_focus_rcv);
        all_topic_recommend_rcv = (RecyclerViewForScrollView) view.findViewById(R.id.all_topic_recommend_rcv);
        all_topic_focus_rel = (RelativeLayout) view.findViewById(R.id.all_topic_focus_rel);
        all_topic_recommend_rel = (RelativeLayout) view.findViewById(R.id.all_topic_recommend_rel);
        mDatasf = new ArrayList<RecommendTopic>();
        mDatasr = new ArrayList<RecommendTopic>();
        if (adapterf == null) {
            adapterf = new AllTopicAdapter(mDatasf, context);
        } else {
            adapterf.notifyDataSetChanged();
        }

        if (adapterr == null) {
            adapterr = new AllTopicAdapter(mDatasr, context);
        } else {
            adapterr.notifyDataSetChanged();
        }
        FullyLinearLayoutManager linearLayoutManager = new FullyLinearLayoutManager(context, FullyLinearLayoutManager.VERTICAL, false);
        FullyLinearLayoutManager linearLayoutManager1 = new FullyLinearLayoutManager(context, FullyLinearLayoutManager.VERTICAL, false);
        all_topic_focus_rcv.setLayoutManager(linearLayoutManager);
        all_topic_focus_rcv.setAdapter(adapterf);
        all_topic_recommend_rcv.setLayoutManager(linearLayoutManager1);
        all_topic_recommend_rcv.setAdapter(adapterr);
        adapterf.setOnItemClickLister(new AllTopicAdapter.OnItemClickLister() {
            @Override
            public void onItemClick(View view, int position) {
                if (mDatasf != null && mDatasf.size() > 0) {
                    Intent intent = new Intent();
                    intent.setClass(context, TopicDetailActivity.class);
//                    LogUtil.i("get topic id: " + mDatasf.get(position).getTopic_id());
                    intent.putExtra("topic_id", mDatasf.get(position).getTopic_id());
                    BuryPointUtils.getInstance().createMap()
                            .put("theme_name", mDatasf.get(position).getTopic_title() == null ? "" : mDatasf.get(position).getTopic_title())
                            .put("theme_ID", mDatasf.get(position).getTopic_id() == null ? "" : mDatasf.get(position).getTopic_id())
                            .burryPoint("Theme_click");
                    startActivity(intent);
                }
            }

            @Override
            public void onItemLongClick(View view, int position) {

            }
        });
        adapterr.setOnItemClickLister(new AllTopicAdapter.OnItemClickLister() {
            @Override
            public void onItemClick(View view, int position) {
                if (mDatasr != null && mDatasr.size() > 0) {
                    Intent intent = new Intent();
                    intent.setClass(context, TopicDetailActivity.class);
                    intent.putExtra("topic_id", mDatasr.get(position).getTopic_id());
                    BuryPointUtils.getInstance().createMap()
                            .put("theme_name", mDatasr.get(position).getTopic_title())
                            .put("theme_ID", mDatasr.get(position).getTopic_id())
                            .burryPoint("Theme_click");
                    LogUtil.i("get topic id: " + mDatasr.get(position).getTopic_id());
                    startActivity(intent);
                }
            }

            @Override
            public void onItemLongClick(View view, int position) {

            }
        });
        adapterr.setmOnFocusClickLister(new AllTopicAdapter.OnFocusClickLister() {
            @Override
            public void onFocusClick(View view, int position) {
                if (DynamicIn.INSTANCE.loginByOneKeyLogin(getActivity(), true)) {
                    BuryPointUtils.getInstance().createMap()
                            .put("theme_name", mDatasr.get(position).getTopic_title())
                            .put("theme_ID", mDatasr.get(position).getTopic_id())
                            .burryPoint("Theme_attention");
                    showProgressDialog("");
                    if (mDatasr != null && mDatasr.size() > 0) {
                        TopicFocus(mDatasr.get(position).getTopic_id(), position);
                    }
                }
            }

            @Override
            public void onFocusLongClick(View view, int position) {

            }
        });
    }

    /**
     * 话题关注
     */
    private void TopicFocus(String topic_id, final int position) {
        Command.FocusCmd cmd = new Command.FocusCmd(topic_id, "2");
        DynamicApiUtils.focus(cmd)
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(objectBaseResponse -> {
                    if (objectBaseResponse.code == 0) {

                        if (mDatasf.size() > 0) {

                        } else {
                            all_topic_focus_rel.setVisibility(View.VISIBLE);
                        }
                        mDatasr.get(position).setFocus_state("1");
                        mDatasf.add(mDatasr.get(position));
                        mDatasr.remove(position);
                        adapterr.updateDate(mDatasr);
                        adapterf.updateDate(mDatasf);
                    } else {
                        ToastUtil.toastShort(context, objectBaseResponse.msg);
                    }
                    dismissProgressDialog();
                }, throwable -> {
                    dismissProgressDialog();
                    DynamicApiUtils.handleError(getActivity(), throwable);
                });

    }

    private void initDatas() {
//        List <FormText> formTexts=new ArrayList<FormText>();
//        FormText formtext=new FormText("cate","2");
//        formTexts.add(formtext);
        mDatasf.clear();
        mDatasr.clear();
        Command.AllTopicCmd cmd = new Command.AllTopicCmd("1", "1");
        DynamicApiUtils.fetchTopicList(cmd)
                .compose(RxUtils.resultData())
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(resp -> {
                        mDatasf = resp.my;
                        mDatasr = resp.list;
                        if (mDatasf.size() > 0) {
                            all_topic_focus_rel.setVisibility(View.VISIBLE);
                        } else {
                            all_topic_focus_rel.setVisibility(View.GONE);
                        }
                        all_topic_recommend_rel.setVisibility(View.VISIBLE);
                        adapterf.updateDate(mDatasf);
                        adapterr.updateDate(mDatasr);

                    dismissProgressDialog();
                }, throwable -> {
                    dismissProgressDialog();
                    DynamicApiUtils.handleError(getActivity(), throwable);
                });
    }


    @Override
    public void onResume() {
        super.onResume();
        showProgressDialog("");
        initDatas();
    }
}
