package com.yidianling.dynamic.trendList;

import android.view.View;

import com.yidianling.dynamic.model.TopicListDataBean;
import com.yidianling.dynamic.model.TrendsListBean;
import com.yidianling.dynamic.model.ZanResult;
import com.ydl.ydlcommon.data.http.BaseResponse;

import java.util.List;

/**
 * Created by Jim on 2017/11/10 0010.
 */

public interface ITrendsListPresenter {
    interface onDataLoadCallBackListener {
        void onTrendsListFetched(TrendsListBean trendsListBean);
        void onTrendsListFetchFialed(Throwable e);
        void onRecommendTopicFetched(BaseResponse<TopicListDataBean> topicListDatas);
        void onRecommendTopicFetchFailed(Throwable e);
        void onLikeActionFetchedResult(View view, int position, BaseResponse<ZanResult> zanResultBaseBean, List<TrendsListBean.Trend> mDatas);
        void onLikeActionFailed(Throwable e);
        void onUserTrendFetched(BaseResponse<List<TrendsListBean.Trend>> Response);
        void onUserTrendFetchFailed(Throwable e);
    }
    //加载本地缓存
    void localData(int tab);

    /**
     * 老的 php接口 话题（问答）列表
     * @param tab
     * @param page
     * @param topicId
     * @param lastId
     */
    void fetchPhpTrendsInfo(int tab, int page, int topicId, int lastId);

    /**
     * java 的接口 话题（问答）列表
     * @param tab
     * @param page
     * @param topicId
     * @param lastId
     */
    void fetchTrendsInfo(int tab, int page, int topicId, int lastId);
    void fetchTopicListInfo(int cat, int my);
    void doLikeAction(final View view, final int position, int trendId, final List<TrendsListBean.Trend> mDatas);
    void fetchUserTrendsList(String uid, int page, int tab);
    void onDestroy();

}
