package com.yidianling.dynamic.trendList.adapter;

import android.content.Context;
import android.content.Intent;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.yidianling.dynamic.R;
import com.yidianling.dynamic.common.browsePictures.BrowsePicturesActivity2;
import com.yidianling.dynamic.model.TrendsListBean;
import com.ydl.webview.H5Params;
import com.ydl.webview.NewH5Activity;;
import com.ydl.ydlcommon.view.BaseViewHolder;

import java.util.ArrayList;

/**
 * Created by Jim on 2017/9/27 0027.
 * 动态Item中图片A
 */

public class ItemImageAdapter extends RecyclerView.Adapter<BaseViewHolder> {

    private Context mContext;
    private TrendsListBean.Trend trend;
    public static final int spanCount = 6;

    public ItemImageAdapter(Context context, TrendsListBean.Trend trend) {
        mContext = context;
        this.trend = trend;
    }

    @Override
    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view;
        if (viewType == 0) {
            view = LayoutInflater.from(mContext).inflate(R.layout.dynamic_item_trend_imag, parent, false);
        } else {
            view = LayoutInflater.from(mContext).inflate(R.layout.dynamic_item_trend_imag_ad, parent, false);
        }
        return new BaseViewHolder(view, mContext, viewType);
    }

    @Override
    public void onBindViewHolder(BaseViewHolder holder, int position) {
        holder.setImageWithUrl(R.id.item_trend_img_iv1, trend.smallAttach.get(position))
                .setOnClickListener(R.id.item_trend_img_iv1, v -> {
                    if (trend.isAd == 1) {
                        NewH5Activity.start(mContext, new H5Params(trend.url, null, trend.share));
                        return;
                    }
                    Intent intent = new Intent();
                    intent.setClass(mContext, BrowsePicturesActivity2.class);
                    intent.putExtra("position", position);
                    intent.putExtra("browse_type", "browse");
                    intent.putStringArrayListExtra("allTrendImages", (ArrayList) trend.bigAttach);
//                bd.putParcelableArrayList("allTrendImages", (ArrayList<? extends Parcelable>) trendsDatas.get(mposition).getTrendBigImages());
                    intent.putExtra("trend_id", trend.id);
                    intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    mContext.startActivity(intent);
                });
    }

    @Override
    public int getItemViewType(int position) {
        if(trend.isAd == 1){
            return 1;
        } else {
            return 0;
        }
    }

    @Override
    public int getItemCount() {
        if (null == trend || null == trend.smallAttach){
            return 0;
        }else if (trend.smallAttach.size() > 3) {
            return 3;
        } else {
            return trend.smallAttach.size();
        }
    }

    public static class ItemImagSpanSizeLookup extends GridLayoutManager.SpanSizeLookup {

        private int dataSize;
        private boolean isAd;

        public ItemImagSpanSizeLookup(TrendsListBean.Trend trend) {
            if (null == trend || null == trend.smallAttach){
                this.dataSize = 0;
            }else {
                this.dataSize = trend.smallAttach.size();
            }
            this.isAd = trend.isAd == 1;
        }

        @Override
        public int getSpanSize(int position) {
            if (isAd) {
                return 6;
            }
            if (dataSize >= 3) {
                return spanCount / 3;
            } else {
                return spanCount / 2;
            }
        }
    }

}
