package com.yidianling.dynamic.trendList.adapter;

import android.content.Context;
import android.content.Intent;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.yidianling.dynamic.R;
import com.yidianling.dynamic.model.RecommendTopic;
import com.yidianling.dynamic.topic.topicDetail.TopicDetailActivity;
import com.ydl.ydlcommon.utils.BuryPointUtils;
import com.ydl.ydlcommon.view.BaseViewHolder;

import java.util.List;

/**
 * Created by Jim on 2017/10/9 0009.
 */

public class RecommendTopicListAdapter extends RecyclerView.Adapter<BaseViewHolder> implements View.OnClickListener {

    private Context mContext;
    private List<RecommendTopic> topicDatas;

    public RecommendTopicListAdapter(Context context, List<RecommendTopic> datas) {
        super();
        topicDatas = datas;
        mContext = context;
    }

    public void setDatas(List<RecommendTopic> datas) {
        topicDatas = datas;
    }

    @Override
    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(mContext).inflate(R.layout.dynamic_item_recommend_topic, parent, false);
        return new BaseViewHolder(view, mContext, viewType);
    }

    @Override
    public void onBindViewHolder(BaseViewHolder holder, int position) {
        if (topicDatas != null && topicDatas.size() > 0) {
            holder.setText(R.id.item_recommend_topic_tv, topicDatas.get(position).getTopic_title());
            holder.setRecommendTopicImageWithUrl(R.id.item_recommend_topic_iv, topicDatas.get(position).getImg_bg_url());
            holder.setOnClickListener(R.id.recommend_topic_rel, new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    BuryPointUtils.getInstance().createMap()
                            .put("theme_name", topicDatas.get(position).getTopic_title())
                            .put("theme_ID", topicDatas.get(position).getTopic_id())
                            .burryPoint("Theme_click");
                    Intent intent = new Intent();
                    intent.setClass(mContext, TopicDetailActivity.class);
                    intent.putExtra("topic_id", topicDatas.get(position).getTopic_id());
                    intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    mContext.startActivity(intent);
                }
            });
        }
    }

    @Override
    public int getItemCount() {
        return topicDatas != null && topicDatas.size() > 0 ? topicDatas.size() : 0;
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.recommend_topic_rel) {}
    }
}
