package com.yidianling.dynamic.trendsDetail;


import androidx.appcompat.app.AppCompatActivity;

import com.ydl.ydlcommon.data.http.BaseAPIResponse;
import com.ydl.ydlcommon.data.http.BaseResponse;
import com.ydl.ydlcommon.mvp.base.SimplePresenter;
import com.ydl.ydlcommon.utils.UserInfoCache;
import com.yidianling.common.tools.LogUtil;
import com.yidianling.dynamic.bean.DynamicConstants;
import com.yidianling.dynamic.common.net.DynamicApiUtils;
import com.yidianling.dynamic.model.CommentBean;
import com.yidianling.dynamic.model.ExpertBuild;
import com.yidianling.dynamic.model.Focus;
import com.yidianling.dynamic.model.Reply;
import com.yidianling.dynamic.model.TrendsDetailInfoBean;
import com.yidianling.dynamic.model.ZanResult;
import com.yidianling.dynamic.router.DynamicIn;

import java.util.List;

/**
 * Created by Jim on 2017/10/10 0010.
 */

public class ITrendsDetailPresenterImpl extends SimplePresenter<ITrendsDetailView> implements ITrendsDetailPresenter, ITrendsDetailPresenter.OnTrendsDetailDataLoadFinishedListenner {

    private TrendsDetailInteractor mTrendsDetailInteractor;

    public ITrendsDetailPresenterImpl() {
        mTrendsDetailInteractor = new TrendsDetailInteractor();
        mTrendsDetailInteractor.setCallBack(this);
    }

    public void fetchTrendsDetails(int id) {
        if (mView != null) {
            mView.showLoadingView("");
        }
        mTrendsDetailInteractor.fetchTrendsDetails(id);
    }


    public void fetchCommentsDatas(int id, int page, int lastId, int direction) {
        mTrendsDetailInteractor.fetchCommentsDatas(id, page, lastId, direction);
    }

    public void fetchCommentsDatas(int page) {
        mTrendsDetailInteractor.fetchCommentsDatas(page);
    }

    /**
     * 点赞
     */
    public void doLikeAction(int type, int id) {
        mTrendsDetailInteractor.doLikeAction(type, id);
    }


    public void focus(String uid) {
        if (mView != null) {
            mView.showLoadingView("");
        }
        mTrendsDetailInteractor.focus(uid);
    }

    /**
     * //获取举报的内容列表
     */
    public void fetchReportReasonContent(int answerId, String commentContent) {
        if (mView != null) {
            mView.showLoadingView("");
        }
        mTrendsDetailInteractor.fetchReportReasonContent(answerId, commentContent);
    }


    //举报帖子评论
    public void report(int trendId, int type, int reasonId, int answerId, String answerContent) {
        if (mView != null) {
            mView.showLoadingView("");
        }
        mTrendsDetailInteractor.report(trendId, type, reasonId, answerId, answerContent);
    }


    /**
     * //删除帖子或评论
     *
     * @param type 移除类型：1移除评论，2移除动态
     * @param id   评论的id,动态id
     */
    public void delTrendsReply(int type, int id, int position) {
        if (mView != null) {
            mView.showLoadingView("");
        }
        mTrendsDetailInteractor.delTrendsReply(type, id, position);
    }

    public void getExpert(AppCompatActivity activity, String expertUid) {
        mTrendsDetailInteractor.getExpert(activity, expertUid);
    }

    public void commitOrReply(int type, String tid, String content, String replyContent, String toName) {
        if (mView != null) {
            mView.showLoadingView("");
        }
        mTrendsDetailInteractor.commitOrReply(type, tid, content, replyContent, toName);
    }

    @Override
    public void onTrendsDetailFetched(BaseAPIResponse<TrendsDetailInfoBean> trendsDetailInfoBean) {
        mView.hideRefreshProgress();
        mView.hideLoadingView();
        if ("200".equals(trendsDetailInfoBean.code)) {
            mView.showTrendsBodyContent(trendsDetailInfoBean.data.active);
            mView.showZanList(trendsDetailInfoBean.data.members);
            mView.showAds(trendsDetailInfoBean.data.adsData);
//            mView.showCommentsList(trendsDetailInfoBean.data.comments);
        } else if ("-300011".equals(trendsDetailInfoBean.code)) {  //帖子被删除
            mView.showTrendsNotExsitView();
        } else {
            mView.showToast(trendsDetailInfoBean.msg);
        }
    }

    @Override
    public void onTrendsDetailFetchFailed(Throwable e) {
        LogUtil.i("onTrendsDetailFetchFailed: " + e);
        mView.hideRefreshProgress();
        mView.hideLoadingView();
        mView.showTrendsLoadErrorView();
        DynamicApiUtils.handleError((TrendsDetailActivity) mView, e);
    }

    @Override
    public void onCommentsListFetched(List<CommentBean> commentsBean) {
        mView.hideRefreshProgress();
        mView.hideLoadingView();
        mView.showCommentsList(commentsBean);
    }

    @Override
    public void onCommentsListFetchedFailed(Throwable e) {
        LogUtil.i("onCommentsListFetchedFailed: " + e);
        mView.hideRefreshProgress();
        mView.showCommentsLoadError();
        DynamicApiUtils.handleError((TrendsDetailActivity) mView, e);
    }

    @Override
    public void ondoLikeActionFetchedResult(BaseResponse<ZanResult> zanResultBaseBean, int type) {
        mView.hideLoadingView();
        if (zanResultBaseBean.code == 0) {
            if (type == 2) {       //帖子点赞
                switch (zanResultBaseBean.data.status) {
                    case 1:         //已赞
                        LogUtil.d("like state 2");
                        mView.showLikedView();
                        break;
                    case 2:     //未赞
                        LogUtil.d("like state 2");
                        mView.showUnLikeView();
                        break;
                }
            } else if (type == 3) {     //动态回复点赞
                mView.showCommentsItemLikeStatus(zanResultBaseBean.data.status);
            }
        } else {
            mView.showToast(zanResultBaseBean.msg);
        }
    }

    @Override
    public void onFoucusActionSuccessed(BaseResponse<Focus> response) {
        if (response.code == 0) {
            mView.hideLoadingView();
            mView.showFousChangeView();
        } else {
            mView.hideLoadingView();
            mView.showToast(response.msg);
        }

    }

    @Override
    public void onReportContentFetched(BaseResponse response, int answerId, String commentContent) {
        if (response.code == 0) {
            mView.hideLoadingView();
            mView.showReportContentView(response, answerId, commentContent);
        } else {
            mView.showToast(response.msg);
        }
    }

    @Override
    public void onReportSuccessed(BaseResponse<Object> response) {
        mView.hideLoadingView();
        if (response.code == 0) {
            mView.showToast("举报信息已提交 谢谢");
        } else {
            mView.showToast(response.msg);
        }
    }

    @Override
    public void onGetExpertSuccesssed(BaseResponse<ExpertBuild> response) {
        if (response.code == 0 || response.code == 200) {
            ExpertBuild expert = response.data;
            UserInfoCache.getInstance().saveYDLUser(expert.shareData.toUid, expert.shareData.name, expert.shareData.cover);
            DynamicIn.INSTANCE.startChat((AppCompatActivity) mView, expert.shareData.toUid);
        } else {
            mView.showToast(response.msg);
        }
    }

    @Override
    public void onCommentOrReplySuccessed(BaseResponse<Reply> replyBaseResponse, int type, String content, String replyContent, String toName) {
        mView.hideLoadingView();
        if (replyBaseResponse.code == 0) {
            mView.refreshCommentListAfterComment(replyBaseResponse, type, content, replyContent, toName);
        } else if (replyBaseResponse.code == DynamicConstants.SILENCED_CODE) {
            mView.showSilencedDialog(replyBaseResponse.data.tips, replyBaseResponse.data.url);
        } else {
            mView.showToast(replyBaseResponse.msg);
        }
    }

    @Override
    public void onDeleteSuccessed(BaseResponse<Object> response, int type, int position) {
        mView.hideLoadingView();
        if (response.code == 0) {
            mView.showDeleteReplyOrTrendView(response, type, position);
        } else {
            mView.showToast(response.msg);
        }
    }

    @Override
    public void showDataLoadErrorView(Throwable e) {
        LogUtil.d("showDataLoadErrorView: " + e);
        mView.hideLoadingView();
        mView.hideRefreshProgress();
        DynamicApiUtils.handleError((TrendsDetailActivity) mView, e);
    }
}
