package com.yidianling.fm;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import androidx.fragment.app.Fragment;
import androidx.viewpager.widget.ViewPager;
import android.widget.PopupWindow;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.ydl.ydlcommon.adapter.FragmentWithTabPagerAdapter;
import com.ydl.ydlcommon.base.BaseActivity;
import com.ydl.ydlcommon.bean.StatusBarOptions;
import com.ydl.ydlcommon.utils.PopUtils;
import com.ydl.ydlcommon.utils.bitmap.ColorUtil;
import com.ydl.ydlcommon.view.SlidingTabLayout;
import com.ydl.ydlcommon.view.TitleBar;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;

/**
 * 电台
 * Created by softrice on 15/12/11.
 */
@Route(path = "/fm/list")
public class FMActivity extends BaseActivity {

    private TitleBar tb_title;
    private SlidingTabLayout stl_tab;
    private ViewPager vp_content;

    private List<String> titleList = new ArrayList<>();
    private List<Fragment> fragmentList = new ArrayList<>();

    private PopupWindow popupWindow;

    @NotNull
    @Override
    public StatusBarOptions getStatusViewOptions() {
        return new StatusBarOptions(true,true);
    }

    public static Intent newIntent(Activity activity) {
        Intent intent = new Intent(activity, FMActivity.class);
        return intent;
    }
    @Override
    protected int layoutResId() {
        return R.layout.fm_activity_fm;
    }

    @Override
    protected void initDataAndEvent() {
        tb_title = findViewById(R.id.tb_title);
        stl_tab = findViewById(R.id.stl_tab);
        vp_content = findViewById(R.id.vp_content);
        initTags();
        tb_title.setRightImageListener(v -> popupWindow = PopUtils.showMoreItem(FMActivity.this,
                tb_title.getRootView(),
                0,
                0));
        tb_title.setRightImageIfShouldSee();
    }


    @Override
    public void onBackPressed() {
        if (popupWindow != null && popupWindow.isShowing()) {
            popupWindow.dismiss();
            return;
        }
        super.onBackPressed();
    }

    /**
     * 初始化tab
     */
    private void initTags() {
        titleList.add("全部");
        titleList.add("我喜欢的");
        for (int i = 0; i < 2; i++) {
            fragmentList.add(new FMListViewFragment().setTagId(i));
        }
        FragmentWithTabPagerAdapter adapter = new FragmentWithTabPagerAdapter(getSupportFragmentManager(), titleList, fragmentList);
        stl_tab.setBackgroundColor(Color.WHITE);
        stl_tab.setSelectedIndicatorColors(ColorUtil.changeColor(this, R.color.platform_main_theme));
        stl_tab.setSelectColor(ColorUtil.changeColor(this, R.color.platform_main_theme));
        vp_content.setAdapter(adapter);
        stl_tab.setIsDoubleTab(true);
        stl_tab.setDividerColors(Color.TRANSPARENT);
        stl_tab.setViewPager(vp_content);
        vp_content.setCurrentItem(0);
    }

    @Override
    protected void onResume() {
        super.onResume();
/*        if (FMOut.INSTANCE.isHansUnread()) {
            tb_title.setImage_right(getResources().getDrawable(R.drawable.more12r));
        } else {
            tb_title.setImage_right(getResources().getDrawable(R.drawable.more12x));
        }*/
    }

    @Override
    protected void onPause() {
        super.onPause();
    }
}
