package com.yidianling.fm.http

import com.ydl.ydlcommon.base.config.YDL_DOMAIN
import com.ydl.ydlcommon.base.config.YDL_DOMAIN_JAVA
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import com.yidianling.fm.response.FMDetail
import com.yidianling.fm.response.FMList
import com.yidianling.fm.response.FavFM
import io.reactivex.Observable
import retrofit2.http.*

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/03/05
 */
interface FMApi {

    @Headers( YDL_DOMAIN + YDL_DOMAIN_JAVA)
    //获得收藏电台
    @GET("fm/list/my")
    fun getFavFMs(@QueryMap params: Map<String, String>): Observable<BaseAPIResponse<FMList>>

    @Headers( YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    //全部电台
    @GET("fm/list/all")
    fun getAllFMs(@QueryMap params: Map<String, String>): Observable<BaseAPIResponse<FMList>>

    //电台详情
    @FormUrlEncoded
    @POST("fm/detail")
    fun fmDetail(@FieldMap params: Map<String, String>): Observable<BaseResponse<FMDetail>>

    //收藏电台
    @FormUrlEncoded
    @POST("favorite/like")
    fun favFM(@FieldMap params: Map<String, String>): Observable<BaseResponse<FavFM>>
}