package com.yidianling.fm.http

import com.ydl.ydlcommon.data.http.*
import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.fm.param.DetailParam
import com.yidianling.fm.param.FMParam
import com.yidianling.fm.param.FavParam
import com.yidianling.fm.response.FMDetail
import com.yidianling.fm.response.FMList
import com.yidianling.fm.response.FavFM
import io.reactivex.Observable
import java.util.ArrayList
import java.util.HashMap

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/03/05
 */
class FMHttpImpl private constructor() : FMHttp {

    companion object {
        fun getInstance(): FMHttpImpl {
            return Holder.INSTANCE
        }

        fun clearFMApi() {
            Holder.INSTANCE.fmApi = null
        }
    }

    private var fmApi: FMApi? = null

    private fun getFMApi(): FMApi {
        if (fmApi == null) {
            fmApi = YDLHttpUtils.obtainApi(FMApi::class.java)
        }
        return fmApi!!
    }

    override fun getFavFMs(fmParam: FMParam): Observable<BaseAPIResponse<FMList>> {
        return RxUtils.mapObservable(fmParam).flatMap { getFMApi().getFavFMs(it) }
    }

    override fun getAllFMs(fmParam: FMParam): Observable<BaseAPIResponse<FMList>> {
        return RxUtils.mapObservable(fmParam).flatMap { getFMApi().getAllFMs(it) }
    }

    override fun fmDetail(param: DetailParam): Observable<BaseResponse<FMDetail>> {
        return RxUtils.mapObservable(param)
                .flatMap { getFMApi().fmDetail(it) }
    }

    override fun favFM(param: FavParam): Observable<BaseResponse<FavFM>> {
        return RxUtils.mapObservable(param)
                .flatMap { getFMApi().favFM(it) }
    }


    private object Holder {
        val INSTANCE = FMHttpImpl()
    }

}