package com.yidianling.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.yidianling.home.R
import com.yidianling.home.model.bean.MeditationModuleBean

class MeditationViewPagerAdapter(private val context: Context, private val data:
    MeditationModuleBean)
    :RecyclerView.Adapter<MeditationViewPagerAdapter.MeditationViewPagerViewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): MeditationViewPagerViewHolder {
        return MeditationViewPagerViewHolder(LayoutInflater
            .from(context).inflate(R.layout.home_layout_meditation_entrance,parent,false))
    }

    override fun onBindViewHolder(holder: MeditationViewPagerViewHolder, position: Int) {
        holder.rv?.also { rv->
            rv.layoutManager = LinearLayoutManager(context,LinearLayoutManager.HORIZONTAL,false)
            rv.adapter =
                data.mditationListResponse?.get(position)?.let {
                    MeditationTypeAdapter(context = context,
                        data = it.mditationResponseList,
                        moreLink = it.lowerFloorMore?:"",
                        homeLink = it.mditationDetailUrl,
                        cateId = it.cateId,
                        buried = it.buried,
                        mark = it.mark,
                        meditationType = it.meditionType)
                }
        }
    }

    override fun getItemCount(): Int {
        return data.mditationListResponse?.size?:0
    }

    inner class MeditationViewPagerViewHolder(itemView: View):RecyclerView.ViewHolder(itemView){
        val rv:RecyclerView? = itemView.findViewById(R.id.rv_meditation_type)
    }

}

