package com.yidianling.home.http

import com.ydl.ydlcommon.base.BaseApp
import com.ydl.ydlcommon.base.config.YDL_DOMAIN
import com.ydl.ydlcommon.base.config.YDL_DOMAIN_JAVA
import com.ydl.ydlcommon.data.PlatformDataManager
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlcommon.router.YdlCommonOut
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.home.model.bean.*
import io.reactivex.Observable
import retrofit2.http.*

/**
 * @author jiucheng
 * @描述:首页接口api
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/22
 */
interface HomeBasePagerApi {
    /**
     * 首页头部数据 Banner&分类
     */
    @GET("home/index")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getHomeHeaderData(@Query("cateSource") cateSource: Int): Observable<BaseAPIResponse<HomeHeaderBean>>

    /**
     * 首页咨询请求
     * goodType 为空或不传 则获取默认类型数据
     */
    @GET("doctor/nlist")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getConsultData(
        @Query("directionTags") category: String,
        @Query("limit") limit: String = "3",
        @Query("page") page: String = "1",
        @Query("uid") uid: String,
        @Query("searchWord") searchWord: String = "",
        @Query("showType") showType: String = "0",
        @Query("ffrom") ffrom: String = PlatformDataManager.getRam().getChannelName(),
        @Query("version") version: String = RxDeviceTool.getAppVersionName(BaseApp.getApp())
    ): Observable<BaseAPIResponse<HomeConsultBean>>

    /**
     * 首页倾述请求
     * goodType 为空或不传 则获取默认类型数据
     */
    @GET("auth/listen/nsearch")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getConfideData(
        @Query("goodType") goodType: String,
        @Query("limit") limit: String = "3",
        @Query("page") page: String = "1",
        // 1: 查询第一个类型列表，较goodType比，低优先级
        @Query("isDefaultType") isDefaultType: String = "1",
        @Query("uid") uid: String,
        @Query("ffrom") ffrom: String = PlatformDataManager.getRam().getChannelName(),
        @Query("version") version: String = RxDeviceTool.getAppVersionName(BaseApp.getApp())
    ): Observable<BaseAPIResponse<HomeConfideBean>>

    //首页课程请求
    @GET("auth/course/getList")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getCourseData(
        @Query("listType") listType: String = "10",
        @Query("limit") limit: String = "3",
        @Query("uid") uid: String,
        @Query("ffrom") ffrom: String = PlatformDataManager.getRam().getChannelName(),
        @Query("version") version: String = RxDeviceTool.getAppVersionName(BaseApp.getApp())
    ): Observable<BaseAPIResponse<HomeCourseBean>>

    //首页测试请求
    @GET("test-item/home-recommend")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getTestData(
        @Query("uid") uid: String,
        @Query("ffrom") ffrom: String = PlatformDataManager.getRam().getChannelName(),
        @Query("version") version: String = RxDeviceTool.getAppVersionName(BaseApp.getApp())
    ): Observable<BaseAPIResponse<MutableList<HomeTestItemBean>>>

    //首页问答请求
    @GET("ask/list-old")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getAskData(
        @Query("perPageRows") perPageRows: String = "6",
        @Query("tab") tab: String = "2",
        @Query("accessToken") accessToken: String,
        @Query("uid") uid: String
    ): Observable<BaseAPIResponse<HomeAskBean>>

    //首页电台请求
    @GET("fm/list/all")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getFMData(@Query("perPageRows") perPageRows: String = "4"): Observable<BaseAPIResponse<HomeFMBean>>

    //首页文章请求   文章改版需求改为3条
    @GET("newArticle/list/all")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getArticleData(@Query("perPageRows") perPageRows: String = "3"): Observable<BaseAPIResponse<HomeArticleBean>>

    //首页问答 - 点赞
    @FormUrlEncoded
    @POST("sq-active/zan")
    fun askZan(@FieldMap params: Map<String, String>): Observable<BaseResponse<AskResultBean>>

    //首页问答 - 关注
    @FormUrlEncoded
    @POST("sq-active/focus")
    fun askFocus(@FieldMap params: Map<String, String>): Observable<BaseResponse<AskResultBean>>

    @GET("cms/meditation/index")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getMeditation(): Observable<BaseAPIResponse<MeditationModuleBean>>

}