package com.yidianling.home.dialog

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.view.Window
import com.ydl.ydl_image.module.GlideApp
import com.ydl.ydlcommon.utils.DisplayUtils
import com.yidianling.home.R
import kotlinx.android.synthetic.xlzx.home_dialog_guide_activity.*
import java.util.*

/**
 * 首页活动引导弹窗
 */
class ActivityGuideDialog : Dialog{

    private var imgUrl :String?= null
    private var title:String? = null
    private var marginTop: Int? = null
    private var marginLeft: Int? = null

    constructor(context: Context,imgUrl: String?,title: String?,marginTop : Int,marginLeft:Int):super(context,R.style.activityDialog){
        this.imgUrl = imgUrl
        this.title = title
        this.marginTop = marginTop
        this.marginLeft = marginLeft
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        requestWindowFeature(Window.FEATURE_NO_TITLE)
        window.setBackgroundDrawableResource(android.R.color.transparent)

        setContentView(R.layout.home_dialog_guide_activity)

        initView()
    }

    private fun initView(){

        if (marginTop==null){
            marginTop = DisplayUtils.dp2px(context,135)
        }
        if (marginLeft==null){
            marginLeft = DisplayUtils.dp2px(context,35)
        }

        c_body.setPadding(marginLeft!!,marginTop!!,0,0)

        c_body.setOnClickListener {
            dismiss()
        }

        tv_content.text = this.title

        GlideApp.with(context).load(imgUrl).into(img_activity)

        //3秒自动消失
        Timer().schedule(object : TimerTask() {
            override fun run() {
                dismiss()
            }
        },3000)
    }

}